% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KO_evaluation.R
\name{KO_evaluation}
\alias{KO_evaluation}
\title{evaluate performance of KKO selection}
\usage{
KO_evaluation(W, reg_coef, fdr_range = 0.2, offset = 1)
}
\arguments{
\item{W}{importance scores of variables.}

\item{reg_coef}{true regression coefficient.}

\item{fdr_range}{FDR control levels of knockoff filter.}

\item{offset}{0/1. If 1, knockoff+ filter. Otherwise, knockoff filter.}
}
\value{
{FDP, FPR, TPR} of knockoff filtering at fdr_range.
}
\description{
The function computes \{FDP, FPR, TPR\} of selection by knockoff filtering on importance scores of KKO.
}
\examples{
library(knockoff)
p=5 # number of predictors
sig_mag=100 # signal strength
n= 100 # sample size
rkernel="laplacian" # kernel choice
s=2  # sparsity, number of nonzero component functions
rk_scale=1  # scaling paramtere of kernel
rfn_range=c(2,3,4)  # number of random features
cv_folds=15  # folds of cross-validation in group lasso
n_stb=10 # number of subsampling for importance scores
n_stb_tune=5 # number of subsampling for tuning random feature number
frac_stb=1/2 # fraction of subsample
nCores_para=2 # number of cores for parallelization
X=matrix(rnorm(n*p),n,p)\%*\%chol(toeplitz(0.3^(0:(p-1))))   # generate design
X_k = create.second_order(X) # generate knockoff
reg_coef=c(rep(1,s),rep(0,p-s))  # regression coefficient
reg_coef=reg_coef*(2*(rnorm(p)>0)-1)*sig_mag
y=X\%*\% reg_coef + rnorm(n) # response

kko_fit=kko(X,y,X_k,rfn_range,n_stb_tune,n_stb,cv_folds,frac_stb,nCores_para,rkernel,rk_scale)
W=kko_fit$importance_score
fdr_range=c(0.2,0.3,0.4,0.5)
KO_evaluation(W,reg_coef,fdr_range,offset=1)


}
\author{
Xiaowu Dai, Xiang Lyu, Lexin Li
}
