% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-analytical.R
\name{kld_discrete}
\alias{kld_discrete}
\title{Analytical KL divergence for two discrete distributions}
\usage{
kld_discrete(P, Q)
}
\arguments{
\item{P, Q}{Numerical arrays with the same dimensions, representing discrete
probability distributions}
}
\value{
A scalar (the Kullback-Leibler divergence)
}
\description{
Analytical KL divergence for two discrete distributions
}
\examples{
# 1-D example
P <- 1:4/10
Q <- rep(0.25,4)
kld_discrete(P,Q)

# The above example in 2-D
P <- matrix(1:4/10,nrow=2)
Q <- matrix(0.25,nrow=2,ncol=2)
kld_discrete(P,Q)

}
