% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rgeo_kriging.R
\name{Rgeo_kriging}
\alias{Rgeo_kriging}
\title{Kriging Interpolation for Databases}
\usage{
Rgeo_kriging(db, model, dx = NA, dy = NA)
}
\arguments{
\item{db}{A db-class object. Should be created using the \code{Rgeo_database()} function.}

\item{model}{An S4 plottable Rgeostats omnidirectional variogram model.
Should be created using the \code{Rgeo_vario_model()} function.}

\item{dx}{Optional. The grid cell size in the x-direction. If not provided, it is calculated
as the average of the ranges in x and y directions divided by 50.}

\item{dy}{Optional. The grid cell size in the y-direction. If not provided, it is calculated
as the average of the ranges in x and y directions divided by 50.}
}
\value{
A S4 plottable Rgeostats kriged database. Can be plotted using the
\code{Rgeo_kriging_plot} function. Summary statistics for the kriging process
can be printed by simply calling the returned dbgrid3 object.
}
\description{
Performs kriging interpolation on a provided database using 'RGeostats' methods.
The data is interpolated over a grid covering the entire area of interest.
}
\details{
The \code{Rgeo_kriging()} function performs kriging interpolation based on the provided
database (db) and variogram model (model). The grid cell sizes \code{dx} and \code{dy}
can be optionally specified or will be automatically determined based on the data.
Results can be visualized with the \code{Rgeo_kriging_plot()} function and summary statistics
can be printed by simply calling the returned kriged object.
}
\examples{
if(requireNamespace("RGeostats", quietly = TRUE)){
    library(RGeostats)
    data("Klovan_Row80", package = "klovan")
    db <- Rgeo_database(Klovan_Row80, 3, "RC3")
    model <- Rgeo_vario_model(db, 3, "RC3", lag = 500, model = 13)
    krig <- Rgeo_kriging(db, model)
    krig # prints summary statistics for kriging
}

}
