% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scree_plot.R
\name{scree_plot}
\alias{scree_plot}
\title{scree plot}
\usage{
scree_plot(
  EigenPlot,
  bar_fill = "lightblue",
  outline = "darkblue",
  eigen_line = "red",
  cum_eigen_line = "blue"
)
}
\arguments{
\item{EigenPlot}{A dataset of class data.frame. The data should contain 'C_X' and 'C_Y' columns
representing the x and y coordinates of the data points and excludes any rank,
ID, or column not for analysis, see README for details or,
a covariance matrix that will be converted into a plottable data frame or,
a plottable data frame created by the \code{eigen_contribution()} function}

\item{bar_fill}{an R color, The fill color for the bars, defaults to "lightblue"}

\item{outline}{an R color, the outline color of the bars, defaults to "darkblue"}

\item{eigen_line}{an R color, the color of the eigenvalues line, defaults to "red"}

\item{cum_eigen_line}{an R color, the color of the cummulative eigenvalues line, defaults to "blue"}
}
\value{
a ggplot object of the scree plot
}
\description{
scree plot
}
\examples{
data("Klovan_Row80")
scree_plot(eigen_contribution(covar_mtrx(Klovan_Row80)))


Scree1 <- scree_plot(Klovan_Row80)
Scree1

your_eigen_data1 <- eigen_contribution(Klovan_Row80)
scree_plot(your_eigen_data1)

}
