% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STUDY_ACROSS_POPULATIONS.R
\name{STUDY_ACROSS_POPULATIONS}
\alias{STUDY_ACROSS_POPULATIONS}
\title{Study k-mer composition of selected COSMIC causal cancer genes across human
populations worldwide.}
\usage{
STUDY_ACROSS_POPULATIONS(
  kmer.table,
  kmer.cutoff = 5,
  genome.name,
  k,
  db = "refseq",
  central.pattern = NULL,
  population.size = 1e+06,
  selected.genes,
  add.to.existing.population = FALSE,
  output.dir = "study_across_populations/",
  population.snv.dt = NULL,
  loop.chr = TRUE,
  plot = FALSE,
  fasta.path
)
}
\arguments{
\item{kmer.table}{A data.table of kmer table.}

\item{kmer.cutoff}{Percentage of extreme kmers to study. Default to 5.}

\item{genome.name}{UCSC genome name.}

\item{k}{K-mer size.}

\item{db}{Database used by UCSC to generate gene prediction: "refseq" or
"gencode". Default is "refseq".}

\item{central.pattern}{K-mer's central patterns. Default is NULL.}

\item{population.size}{Size of population to simulate. Default is 1 million.}

\item{selected.genes}{Set of genes to study e.g. skin cancer genes.}

\item{add.to.existing.population}{Add counts to counts.csv? Default is
FALSE.}

\item{output.dir}{A directory for the outputs. Default to
study_across_populations.}

\item{population.snv.dt}{Population SNV table.}

\item{loop.chr}{Loop chromosome?. Default is TRUE. If FALSE, beware of a
memory spike because of VCF content. VCF contains zero counts for every
population. Input pre-computed trimmed-version population.snv.dt.}

\item{plot}{Boolean. Default is FALSE. If TRUE, will plot results.}

\item{fasta.path}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}
}
\value{
An output directory containing plots.
}
\description{
Simulation of human population is based on single nucleotide variantion.
}
