% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadNCBIGenomes.R
\name{downloadNCBIGenomes}
\alias{downloadNCBIGenomes}
\title{Function downloads genome fasta files from the NCBI FTP database. Users can
provide either organism names or an assembly summary data table.}
\usage{
downloadNCBIGenomes(
  asm,
  species,
  db,
  output.dir = "./",
  split.fasta = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{asm}{NCBI assembly summary data.table}

\item{species}{Species names.}

\item{db}{Database record to use: refseq or genbank}

\item{output.dir}{Output directory path. Default is current directory.}

\item{split.fasta}{NCBI fasta files are multi-header. Split them? Default is
FALSE.}

\item{overwrite}{Overwrite any existed genome file? Default is FALSE to skip
the download.}
}
\value{
Genome fasta file(s) named according to the FTP database convention.
}
\description{
Supports options for splitting multi-header fasta files and overwriting existing files.
}
