% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateIntergenicCoor.R
\name{generateIntergenicCoor}
\alias{generateIntergenicCoor}
\title{Resolve and generate genic element coordinates from UCSC genePred table.}
\usage{
generateIntergenicCoor(
  genepred,
  genome.name,
  fasta.path,
  igr.rel.pos = c(5000, 7500),
  igr.min.length = 150,
  return.coor.obj = FALSE
)
}
\arguments{
\item{genepred}{UCSC genePred table or database name ("refseq" or "gencode").}

\item{genome.name}{UCSC genome name (e.g., hg38, mm39).}

\item{fasta.path}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}

\item{igr.rel.pos}{Intergenic relative position, defaults to c(5000, 7500).}

\item{igr.min.length}{Minimum length for intergenic regions, default is 150.}

\item{return.coor.obj}{Return results as a \code{Coordinate} object? Default FALSE.}
}
\value{
Intergenic coordinates as a \code{data.table} or \code{Coordinate} object.
}
\description{
Function generates intergenic coordinates from a UCSC genePred table.
It allows users to specify the genePred data source, the relative position
and minimum length for intergenic regions, and whether to return the results
as a \code{Coordinate} object or a \code{data.table}.
}
