% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readKSJData.R
\name{readKSJData}
\alias{readKSJData}
\title{Read JPGIS2.1 Data}
\usage{
readKSJData(x, encoding = "CP932")
}
\arguments{
\item{x}{A path to a ZIP file or to a directory that contains the extracted files.}

\item{encoding}{Encoding of the data.}
}
\description{
\code{readKSJData()} is an utility to read data downloaded from 'Kokudo Suuchi' service.
}
\examples{
\dontrun{
# Download a ZIP file from kokudosuuchi website
zip_file <- tempfile(fileext = ".zip")
url <- "https://nlftp.mlit.go.jp/ksj/gml/data/W07/W07-09/W07-09_3641-jgd_GML.zip"
download.file(url, zip_file)

# Load all data as sf objects
d <- readKSJData(zip_file)

# Translate colnames and 'codelist' type columns
translateKSJData(d)
}

}
