# readKSJData() works

    Code
      translateKSJData(d)
    Output
      $`P11-10_36-jgd-g_BusStop`
      Simple feature collection with 2031 features and 41 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 133.6901 ymin: 33.54718 xmax: 134.6978 ymax: 34.23716
      CRS:            NA
      # A tibble: 2,031 x 42
         バス停名 バス区分 バス区分_code 事業者名_1 事業者名_2 事業者名_3 事業者名_4
         <chr>    <list>   <chr>         <chr>      <chr>      <chr>      <chr>     
       1 鳴門公園口~ <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       2 徳島駅前 <chr [3~ 1,1,1         さんようバス（株）~ <NA>       <NA>       <NA>      
       3 鳴門西   <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       4 板野     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       5 上坂     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       6 土成     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       7 阿波     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       8 脇町     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
       9 美馬     <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
      10 井川（四交前）~ <chr [1~ 1             さんようバス（株）~ <NA>       <NA>       <NA>      
      # ... with 2,021 more rows, and 35 more variables: 事業者名_5 <chr>,
      #   事業者名_6 <chr>, 事業者名_7 <chr>, 事業者名_8 <chr>, 事業者名_9 <chr>,
      #   事業者名_10 <chr>, 事業者名_11 <chr>, 事業者名_12 <chr>, 事業者名_13 <chr>,
      #   事業者名_14 <chr>, 事業者名_15 <chr>, 事業者名_16 <chr>, 事業者名_17 <chr>,
      #   事業者名_18 <chr>, 事業者名_19 <chr>, バス系統_1 <chr>, バス系統_2 <chr>,
      #   バス系統_3 <chr>, バス系統_4 <chr>, バス系統_5 <chr>, バス系統_6 <chr>,
      #   バス系統_7 <chr>, バス系統_8 <chr>, バス系統_9 <chr>, バス系統_10 <chr>,
      #   バス系統_11 <chr>, バス系統_12 <chr>, バス系統_13 <chr>, バス系統_14 <chr>,
      #   バス系統_15 <chr>, バス系統_16 <chr>, バス系統_17 <chr>, バス系統_18 <chr>,
      #   バス系統_19 <chr>, geometry <POINT>
      

---

    Code
      translateKSJData(d, translate_colnames = FALSE)
    Warning <warning>
      There are some columns yet to be translated: P11_001,P11_002,P11_003_1,P11_003_2,P11_003_3,P11_003_4,P11_003_5,P11_003_6,P11_003_7,P11_003_8,P11_003_9,P11_003_10,P11_003_11,P11_003_12,P11_003_13,P11_003_14,P11_003_15,P11_003_16,P11_003_17,P11_003_18,P11_003_19,P11_004_1,P11_004_2,P11_004_3,P11_004_4,P11_004_5,P11_004_6,P11_004_7,P11_004_8,P11_004_9,P11_004_10,P11_004_11,P11_004_12,P11_004_13,P11_004_14,P11_004_15,P11_004_16,P11_004_17,P11_004_18,P11_004_19
    Output
      $`P11-10_36-jgd-g_BusStop`
      Simple feature collection with 2031 features and 41 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 133.6901 ymin: 33.54718 xmax: 134.6978 ymax: 34.23716
      CRS:            NA
      # A tibble: 2,031 x 42
         P11_001 P11_002 P11_002_code P11_003_1 P11_003_2 P11_003_3 P11_003_4
         <chr>   <list>  <chr>        <chr>     <chr>     <chr>     <chr>    
       1 鳴門公園口~ <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       2 徳島駅前~ <chr [~ 1,1,1        さんようバス（株~ <NA>      <NA>      <NA>     
       3 鳴門西  <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       4 板野    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       5 上坂    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       6 土成    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       7 阿波    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       8 脇町    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
       9 美馬    <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
      10 井川（四交前~ <chr [~ 1            さんようバス（株~ <NA>      <NA>      <NA>     
      # ... with 2,021 more rows, and 35 more variables: P11_003_5 <chr>,
      #   P11_003_6 <chr>, P11_003_7 <chr>, P11_003_8 <chr>, P11_003_9 <chr>,
      #   P11_003_10 <chr>, P11_003_11 <chr>, P11_003_12 <chr>, P11_003_13 <chr>,
      #   P11_003_14 <chr>, P11_003_15 <chr>, P11_003_16 <chr>, P11_003_17 <chr>,
      #   P11_003_18 <chr>, P11_003_19 <chr>, P11_004_1 <chr>, P11_004_2 <chr>,
      #   P11_004_3 <chr>, P11_004_4 <chr>, P11_004_5 <chr>, P11_004_6 <chr>,
      #   P11_004_7 <chr>, P11_004_8 <chr>, P11_004_9 <chr>, P11_004_10 <chr>,
      #   P11_004_11 <chr>, P11_004_12 <chr>, P11_004_13 <chr>, P11_004_14 <chr>,
      #   P11_004_15 <chr>, P11_004_16 <chr>, P11_004_17 <chr>, P11_004_18 <chr>,
      #   P11_004_19 <chr>, geometry <POINT>
      

---

    Code
      translateKSJData(d, translate_codelist = FALSE)
    Output
      $`P11-10_36-jgd-g_BusStop`
      Simple feature collection with 2031 features and 40 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 133.6901 ymin: 33.54718 xmax: 134.6978 ymax: 34.23716
      CRS:            NA
      # A tibble: 2,031 x 41
         バス停名 バス区分 事業者名_1 事業者名_2 事業者名_3 事業者名_4 事業者名_5
         <chr>    <chr>    <chr>      <chr>      <chr>      <chr>      <chr>     
       1 鳴門公園口~ 1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       2 徳島駅前 1,1,1    さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       3 鳴門西   1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       4 板野     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       5 上坂     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       6 土成     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       7 阿波     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       8 脇町     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
       9 美馬     1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
      10 井川（四交前）~ 1        さんようバス（株）~ <NA>       <NA>       <NA>       <NA>      
      # ... with 2,021 more rows, and 34 more variables: 事業者名_6 <chr>,
      #   事業者名_7 <chr>, 事業者名_8 <chr>, 事業者名_9 <chr>, 事業者名_10 <chr>,
      #   事業者名_11 <chr>, 事業者名_12 <chr>, 事業者名_13 <chr>, 事業者名_14 <chr>,
      #   事業者名_15 <chr>, 事業者名_16 <chr>, 事業者名_17 <chr>, 事業者名_18 <chr>,
      #   事業者名_19 <chr>, バス系統_1 <chr>, バス系統_2 <chr>, バス系統_3 <chr>,
      #   バス系統_4 <chr>, バス系統_5 <chr>, バス系統_6 <chr>, バス系統_7 <chr>,
      #   バス系統_8 <chr>, バス系統_9 <chr>, バス系統_10 <chr>, バス系統_11 <chr>,
      #   バス系統_12 <chr>, バス系統_13 <chr>, バス系統_14 <chr>, バス系統_15 <chr>,
      #   バス系統_16 <chr>, バス系統_17 <chr>, バス系統_18 <chr>, バス系統_19 <chr>,
      #   geometry <POINT>
      

---

    Code
      translateKSJData(d_A03)
    Output
      $`A03-03_SYUTO-g_ThreeMajorMetroPlanArea`
      Simple feature collection with 1300 features and 9 fields
      geometry type:  POLYGON
      dimension:      XY
      bbox:           xmin: 136.0722 ymin: 20.42072 xmax: 153.9866 ymax: 37.15198
      CRS:            NA
      # A tibble: 1,300 x 10
         行政区域コード 都道府県名 郡市名 区町村名 陸水等区分 区域区分 区域コード
       * <chr>          <chr>      <chr>  <chr>    <chr>      <chr>    <list>    
       1 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       2 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       3 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       4 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       5 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       6 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       7 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       8 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
       9 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
      10 13421          東京都     小笠原支庁~ 小笠原村 1          無指定   <chr [0]> 
      # ... with 1,290 more rows, and 3 more variables: 区域コード_code <chr>,
      #   備考 <chr>, geometry <POLYGON>
      

---

    Code
      translateKSJData(d_A22_m)
    Output
      $`A22-m-14_MaxSnowDepth_34`
      Simple feature collection with 30 features and 149 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 132.1416 ymin: 34.48692 xmax: 133.2783 ymax: 35.06595
      geographic CRS: JGD2011
      # A tibble: 30 x 150
         観測点名 観測点の所在地 観測点の管理者 `各年度別最深積雪（平均値）`~ `各年度別最深積雪（最大値）`~
         <chr>    <chr>          <chr>                     <dbl>            <dbl>
       1 布野     三次市布野町上布野~ 中国地方整備局             25.9               40
       2 横谷     三次市布野町横谷~ 中国地方整備局            107                199
       3 廿日市市吉和支~ 廿日市市吉和3425番1~ 廿日市市                   66.9              155
       4 溝口     山県郡芸北町大字溝口字大崎~ 国土交通省水管理・国土保全~             93.1              150
       5 東城     庄原市東城町川西~ 国土交通省水管理・国土保全~             27.5               50
       6 豊平     山県郡北広島町志路原鳥越~ 広島県                     56.4              109
       7 芸北     山県郡北広島町川小田~ 広島県                     87.3              176
       8 千代田   山県郡北広島町有田~ 広島県                     30.0              103
       9 大朝     山県郡北広島町大朝鳴滝~ 広島県                     64.0              156
      10 戸河内   山県郡安芸大田町川手~ 広島県                     49.0              120
      # ... with 20 more rows, and 145 more variables: 最深積雪_2013年度 <dbl>,
      #   最深積雪_2012年度 <dbl>, 最深積雪_2011年度 <dbl>, 最深積雪_2010年度 <dbl>,
      #   最深積雪_2009年度 <dbl>, 最深積雪_2008年度 <dbl>, 最深積雪_2007年度 <dbl>,
      #   最深積雪_2006年度 <dbl>, 最深積雪_2005年度 <dbl>, 最深積雪_2004年度 <dbl>,
      #   最深積雪_2003年度 <dbl>, 最深積雪_2002年度 <dbl>, 最深積雪_2001年度 <dbl>,
      #   最深積雪_2000年度 <dbl>, 最深積雪_1999年度 <dbl>, 最深積雪_1998年度 <dbl>,
      #   最深積雪_1997年度 <dbl>, 最深積雪_1996年度 <dbl>, 最深積雪_1995年度 <dbl>,
      #   最深積雪_1994年度 <dbl>, 最深積雪_1993年度 <dbl>, 最深積雪_1992年度 <dbl>,
      #   最深積雪_1991年度 <dbl>, 最深積雪_1990年度 <dbl>, 最深積雪_1989年度 <dbl>,
      #   最深積雪_1988年度 <dbl>, 最深積雪_1987年度 <dbl>, 最深積雪_1986年度 <dbl>,
      #   最深積雪_1985年度 <dbl>, 最深積雪_1984年度 <dbl>, 最深積雪_1983年度 <dbl>,
      #   最深積雪_1982年度 <dbl>, 最深積雪_1981年度 <dbl>, 最深積雪_1980年度 <dbl>,
      #   最深積雪_1979年度 <dbl>, 最深積雪_1978年度 <dbl>, 最深積雪_1977年度 <dbl>,
      #   最深積雪_1976年度 <dbl>, 最深積雪_1975年度 <dbl>, 最深積雪_1974年度 <dbl>,
      #   最深積雪_1973年度 <dbl>, 最深積雪_1972年度 <dbl>, 最深積雪_1971年度 <dbl>,
      #   最深積雪_1970年度 <dbl>, 最深積雪_1969年度 <dbl>, 最深積雪_1968年度 <dbl>,
      #   最深積雪_1967年度 <dbl>, 最深積雪_1966年度 <dbl>, 最深積雪_1965年度 <dbl>,
      #   最深積雪_1964年度 <dbl>, 最深積雪_1963年度 <dbl>, 最深積雪_1962年度 <dbl>,
      #   最深積雪_1961年度 <dbl>, 最深積雪_1960年度 <dbl>, 最深積雪_1959年度 <dbl>,
      #   最深積雪_1958年度 <dbl>, 最深積雪_1957年度 <dbl>, 最深積雪_1956年度 <dbl>,
      #   最深積雪_1955年度 <dbl>, 最深積雪_1954年度 <dbl>, 最深積雪_1953年度 <dbl>,
      #   最深積雪_1952年度 <dbl>, 最深積雪_1951年度 <dbl>, 最深積雪_1950年度 <dbl>,
      #   最深積雪_1949年度 <dbl>, 最深積雪_1948年度 <dbl>, 最深積雪_1947年度 <dbl>,
      #   最深積雪_1946年度 <dbl>, 最深積雪_1945年度 <dbl>, 最深積雪_1944年度 <dbl>,
      #   最深積雪_1943年度 <dbl>, 最深積雪_1942年度 <dbl>, 最深積雪_1941年度 <dbl>,
      #   最深積雪_1940年度 <dbl>, 最深積雪_1939年度 <dbl>, 最深積雪_1938年度 <dbl>,
      #   最深積雪_1937年度 <dbl>, 最深積雪_1936年度 <dbl>, 最深積雪_1935年度 <dbl>,
      #   最深積雪_1934年度 <dbl>, 最深積雪_1933年度 <dbl>, 最深積雪_1932年度 <dbl>,
      #   最深積雪_1931年度 <dbl>, 最深積雪_1930年度 <dbl>, 最深積雪_1929年度 <dbl>,
      #   最深積雪_1928年度 <dbl>, 最深積雪_1927年度 <dbl>, 最深積雪_1926年度 <dbl>,
      #   最深積雪_1925年度 <dbl>, 最深積雪_1924年度 <dbl>, 最深積雪_1923年度 <dbl>,
      #   最深積雪_1922年度 <dbl>, 最深積雪_1921年度 <dbl>, 最深積雪_1920年度 <dbl>,
      #   最深積雪_1919年度 <dbl>, 最深積雪_1918年度 <dbl>, 最深積雪_1917年度 <dbl>,
      #   最深積雪_1916年度 <dbl>, 最深積雪_1915年度 <dbl>, 最深積雪_1914年度 <dbl>,
      #   ...
      
      $`A22-m-14_TotalSnowfall_34`
      Simple feature collection with 26 features and 149 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 132.1416 ymin: 34.48692 xmax: 133.2764 ymax: 35.06595
      geographic CRS: JGD2011
      # A tibble: 26 x 150
         観測点名 観測点の所在地 観測点の管理者 `各年度別累計降雪量（平均値）~ `各年度別累計降雪量（最大値）~
         <chr>    <chr>          <chr>                     <dbl>            <dbl>
       1 横谷     三次市布野町横谷~ 中国地方整備局            452.               821
       2 豊平     山県郡北広島町志路原鳥越~ 広島県                    293.               587
       3 芸北     山県郡北広島町川小田~ 広島県                    420.               789
       4 千代田   山県郡北広島町有田~ 広島県                    143.               317
       5 大朝     山県郡北広島町大朝鳴滝~ 広島県                    310.               762
       6 戸河内   山県郡安芸大田町川手~ 広島県                    235.               477
       7 八幡     山県郡北広島町西八幡原~ 広島県                    558.              1197
       8 吉和     廿日市市吉和   広島県                    346                808
       9 口和     庄原市口和町向泉~ 広島県                    226.               479
      10 東城     庄原市東城町川東~ 広島県                     80.2              210
      # ... with 16 more rows, and 145 more variables: 累計降雪量_2013年度 <dbl>,
      #   累計降雪量_2012年度 <dbl>, 累計降雪量_2011年度 <dbl>,
      #   累計降雪量_2010年度 <dbl>, 累計降雪量_2009年度 <dbl>,
      #   累計降雪量_2008年度 <dbl>, 累計降雪量_2007年度 <dbl>,
      #   累計降雪量_2006年度 <dbl>, 累計降雪量_2005年度 <dbl>,
      #   累計降雪量_2004年度 <dbl>, 累計降雪量_2003年度 <dbl>,
      #   累計降雪量_2002年度 <dbl>, 累計降雪量_2001年度 <dbl>,
      #   累計降雪量_2000年度 <dbl>, 累計降雪量_1999年度 <dbl>,
      #   累計降雪量_1998年度 <dbl>, 累計降雪量_1997年度 <dbl>,
      #   累計降雪量_1996年度 <dbl>, 累計降雪量_1995年度 <dbl>,
      #   累計降雪量_1994年度 <dbl>, 累計降雪量_1993年度 <dbl>,
      #   累計降雪量_1992年度 <dbl>, 累計降雪量_1991年度 <dbl>,
      #   累計降雪量_1990年度 <dbl>, 累計降雪量_1989年度 <dbl>,
      #   累計降雪量_1988年度 <dbl>, 累計降雪量_1987年度 <dbl>,
      #   累計降雪量_1986年度 <dbl>, 累計降雪量_1985年度 <dbl>,
      #   累計降雪量_1984年度 <dbl>, 累計降雪量_1983年度 <dbl>,
      #   累計降雪量_1982年度 <dbl>, 累計降雪量_1981年度 <dbl>,
      #   累計降雪量_1980年度 <dbl>, 累計降雪量_1979年度 <dbl>,
      #   累計降雪量_1978年度 <dbl>, 累計降雪量_1977年度 <dbl>,
      #   累計降雪量_1976年度 <dbl>, 累計降雪量_1975年度 <dbl>,
      #   累計降雪量_1974年度 <dbl>, 累計降雪量_1973年度 <dbl>,
      #   累計降雪量_1972年度 <dbl>, 累計降雪量_1971年度 <dbl>,
      #   累計降雪量_1970年度 <dbl>, 累計降雪量_1969年度 <dbl>,
      #   累計降雪量_1968年度 <dbl>, 累計降雪量_1967年度 <dbl>,
      #   累計降雪量_1966年度 <dbl>, 累計降雪量_1965年度 <dbl>,
      #   累計降雪量_1964年度 <dbl>, 累計降雪量_1963年度 <dbl>,
      #   累計降雪量_1962年度 <dbl>, 累計降雪量_1961年度 <dbl>,
      #   累計降雪量_1960年度 <dbl>, 累計降雪量_1959年度 <dbl>,
      #   累計降雪量_1958年度 <dbl>, 累計降雪量_1957年度 <dbl>,
      #   累計降雪量_1956年度 <dbl>, 累計降雪量_1955年度 <dbl>,
      #   累計降雪量_1954年度 <dbl>, 累計降雪量_1953年度 <dbl>,
      #   累計降雪量_1952年度 <dbl>, 累計降雪量_1951年度 <dbl>,
      #   累計降雪量_1950年度 <dbl>, 累計降雪量_1949年度 <dbl>,
      #   累計降雪量_1948年度 <dbl>, 累計降雪量_1947年度 <dbl>,
      #   累計降雪量_1946年度 <dbl>, 累計降雪量_1945年度 <dbl>,
      #   累計降雪量_1944年度 <dbl>, 累計降雪量_1943年度 <dbl>,
      #   累計降雪量_1942年度 <dbl>, 累計降雪量_1941年度 <dbl>,
      #   累計降雪量_1940年度 <dbl>, 累計降雪量_1939年度 <dbl>,
      #   累計降雪量_1938年度 <dbl>, 累計降雪量_1937年度 <dbl>,
      #   累計降雪量_1936年度 <dbl>, 累計降雪量_1935年度 <dbl>,
      #   累計降雪量_1934年度 <dbl>, 累計降雪量_1933年度 <dbl>,
      #   累計降雪量_1932年度 <dbl>, 累計降雪量_1931年度 <dbl>,
      #   累計降雪量_1930年度 <dbl>, 累計降雪量_1929年度 <dbl>,
      #   累計降雪量_1928年度 <dbl>, 累計降雪量_1927年度 <dbl>,
      #   累計降雪量_1926年度 <dbl>, 累計降雪量_1925年度 <dbl>,
      #   累計降雪量_1924年度 <dbl>, 累計降雪量_1923年度 <dbl>,
      #   累計降雪量_1922年度 <dbl>, 累計降雪量_1921年度 <dbl>,
      #   累計降雪量_1920年度 <dbl>, 累計降雪量_1919年度 <dbl>,
      #   累計降雪量_1918年度 <dbl>, 累計降雪量_1917年度 <dbl>,
      #   累計降雪量_1916年度 <dbl>, 累計降雪量_1915年度 <dbl>,
      #   累計降雪量_1914年度 <dbl>, ...
      
      $`A22-m-14_MinTemperature_34`
      Simple feature collection with 6 features and 149 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 132.142 ymin: 34.48693 xmax: 132.9017 ymax: 35.03333
      geographic CRS: JGD2011
      # A tibble: 6 x 150
        観測点名 観測点の所在地 観測点の管理者 `各年度別最低気温（平均値）`~ `各年度別最低気温（最低値）`~
        <chr>    <chr>          <chr>                     <dbl>            <dbl>
      1 布野     三次市布野町上布野~ 中国地方整備局            -6.94            -12.6
      2 湯谷     三次市布野町上布野~ 中国地方整備局            -7.38            -13.7
      3 横谷     三次市布野町横谷~ 中国地方整備局            -8.39            -11.8
      4 廿日市市吉和支~ 廿日市市吉和3425番1~ 廿日市市                 -13.0             -24.4
      5 高野     庄原市高野町新市~ 国土交通省気象庁~           -14.1             -18.5
      6 大朝     山県郡北広島町大朝字大坪~ 国土交通省気象庁~           -12.1             -18.1
      # ... with 145 more variables: 最低気温_2013年度 <dbl>,
      #   最低気温_2012年度 <dbl>, 最低気温_2011年度 <dbl>, 最低気温_2010年度 <dbl>,
      #   最低気温_2009年度 <dbl>, 最低気温_2008年度 <dbl>, 最低気温_2007年度 <dbl>,
      #   最低気温_2006年度 <dbl>, 最低気温_2005年度 <dbl>, 最低気温_2004年度 <dbl>,
      #   最低気温_2003年度 <dbl>, 最低気温_2002年度 <dbl>, 最低気温_2001年度 <dbl>,
      #   最低気温_2000年度 <dbl>, 最低気温_1999年度 <dbl>, 最低気温_1998年度 <dbl>,
      #   最低気温_1997年度 <dbl>, 最低気温_1996年度 <dbl>, 最低気温_1995年度 <dbl>,
      #   最低気温_1994年度 <dbl>, 最低気温_1993年度 <dbl>, 最低気温_1992年度 <dbl>,
      #   最低気温_1991年度 <dbl>, 最低気温_1990年度 <dbl>, 最低気温_1989年度 <dbl>,
      #   最低気温_1988年度 <dbl>, 最低気温_1987年度 <dbl>, 最低気温_1986年度 <dbl>,
      #   最低気温_1985年度 <dbl>, 最低気温_1984年度 <dbl>, 最低気温_1983年度 <dbl>,
      #   最低気温_1982年度 <dbl>, 最低気温_1981年度 <dbl>, 最低気温_1980年度 <dbl>,
      #   最低気温_1979年度 <dbl>, 最低気温_1978年度 <dbl>, 最低気温_1977年度 <dbl>,
      #   最低気温_1976年度 <dbl>, 最低気温_1975年度 <dbl>, 最低気温_1974年度 <dbl>,
      #   最低気温_1973年度 <dbl>, 最低気温_1972年度 <dbl>, 最低気温_1971年度 <dbl>,
      #   最低気温_1970年度 <dbl>, 最低気温_1969年度 <dbl>, 最低気温_1968年度 <dbl>,
      #   最低気温_1967年度 <dbl>, 最低気温_1966年度 <dbl>, 最低気温_1965年度 <dbl>,
      #   最低気温_1964年度 <dbl>, 最低気温_1963年度 <dbl>, 最低気温_1962年度 <dbl>,
      #   最低気温_1961年度 <dbl>, 最低気温_1960年度 <dbl>, 最低気温_1959年度 <dbl>,
      #   最低気温_1958年度 <dbl>, 最低気温_1957年度 <dbl>, 最低気温_1956年度 <dbl>,
      #   最低気温_1955年度 <dbl>, 最低気温_1954年度 <dbl>, 最低気温_1953年度 <dbl>,
      #   最低気温_1952年度 <dbl>, 最低気温_1951年度 <dbl>, 最低気温_1950年度 <dbl>,
      #   最低気温_1949年度 <dbl>, 最低気温_1948年度 <dbl>, 最低気温_1947年度 <dbl>,
      #   最低気温_1946年度 <dbl>, 最低気温_1945年度 <dbl>, 最低気温_1944年度 <dbl>,
      #   最低気温_1943年度 <dbl>, 最低気温_1942年度 <dbl>, 最低気温_1941年度 <dbl>,
      #   最低気温_1940年度 <dbl>, 最低気温_1939年度 <dbl>, 最低気温_1938年度 <dbl>,
      #   最低気温_1937年度 <dbl>, 最低気温_1936年度 <dbl>, 最低気温_1935年度 <dbl>,
      #   最低気温_1934年度 <dbl>, 最低気温_1933年度 <dbl>, 最低気温_1932年度 <dbl>,
      #   最低気温_1931年度 <dbl>, 最低気温_1930年度 <dbl>, 最低気温_1929年度 <dbl>,
      #   最低気温_1928年度 <dbl>, 最低気温_1927年度 <dbl>, 最低気温_1926年度 <dbl>,
      #   最低気温_1925年度 <dbl>, 最低気温_1924年度 <dbl>, 最低気温_1923年度 <dbl>,
      #   最低気温_1922年度 <dbl>, 最低気温_1921年度 <dbl>, 最低気温_1920年度 <dbl>,
      #   最低気温_1919年度 <dbl>, 最低気温_1918年度 <dbl>, 最低気温_1917年度 <dbl>,
      #   最低気温_1916年度 <dbl>, 最低気温_1915年度 <dbl>, 最低気温_1914年度 <dbl>,
      #   ...
      
      $`A22-m-14_MeanWindSpeed_34`
      Simple feature collection with 2 features and 149 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 132.4633 ymin: 34.76833 xmax: 132.9017 ymax: 35.03333
      geographic CRS: JGD2011
      # A tibble: 2 x 150
        観測点名 観測点の所在地 観測点の管理者 `各年度別平均風速（平均値）`~ `各年度別平均風速（最大値）`~
        <chr>    <chr>          <chr>                     <dbl>            <dbl>
      1 高野     庄原市高野町新市~ 国土交通省気象庁~             1.22             1.48
      2 大朝     山県郡北広島町大朝字大坪~ 国土交通省気象庁~             1.35             1.63
      # ... with 145 more variables: 平均風速_2013年度 <dbl>,
      #   平均風速_2012年度 <dbl>, 平均風速_2011年度 <dbl>, 平均風速_2010年度 <dbl>,
      #   平均風速_2009年度 <dbl>, 平均風速_2008年度 <dbl>, 平均風速_2007年度 <dbl>,
      #   平均風速_2006年度 <dbl>, 平均風速_2005年度 <dbl>, 平均風速_2004年度 <dbl>,
      #   平均風速_2003年度 <dbl>, 平均風速_2002年度 <dbl>, 平均風速_2001年度 <dbl>,
      #   平均風速_2000年度 <dbl>, 平均風速_1999年度 <dbl>, 平均風速_1998年度 <dbl>,
      #   平均風速_1997年度 <dbl>, 平均風速_1996年度 <dbl>, 平均風速_1995年度 <dbl>,
      #   平均風速_1994年度 <dbl>, 平均風速_1993年度 <dbl>, 平均風速_1992年度 <dbl>,
      #   平均風速_1991年度 <dbl>, 平均風速_1990年度 <dbl>, 平均風速_1989年度 <dbl>,
      #   平均風速_1988年度 <dbl>, 平均風速_1987年度 <dbl>, 平均風速_1986年度 <dbl>,
      #   平均風速_1985年度 <dbl>, 平均風速_1984年度 <dbl>, 平均風速_1983年度 <dbl>,
      #   平均風速_1982年度 <dbl>, 平均風速_1981年度 <dbl>, 平均風速_1980年度 <dbl>,
      #   平均風速_1979年度 <dbl>, 平均風速_1978年度 <dbl>, 平均風速_1977年度 <dbl>,
      #   平均風速_1976年度 <dbl>, 平均風速_1975年度 <dbl>, 平均風速_1974年度 <dbl>,
      #   平均風速_1973年度 <dbl>, 平均風速_1972年度 <dbl>, 平均風速_1971年度 <dbl>,
      #   平均風速_1970年度 <dbl>, 平均風速_1969年度 <dbl>, 平均風速_1968年度 <dbl>,
      #   平均風速_1967年度 <dbl>, 平均風速_1966年度 <dbl>, 平均風速_1965年度 <dbl>,
      #   平均風速_1964年度 <dbl>, 平均風速_1963年度 <dbl>, 平均風速_1962年度 <dbl>,
      #   平均風速_1961年度 <dbl>, 平均風速_1960年度 <dbl>, 平均風速_1959年度 <dbl>,
      #   平均風速_1958年度 <dbl>, 平均風速_1957年度 <dbl>, 平均風速_1956年度 <dbl>,
      #   平均風速_1955年度 <dbl>, 平均風速_1954年度 <dbl>, 平均風速_1953年度 <dbl>,
      #   平均風速_1952年度 <dbl>, 平均風速_1951年度 <dbl>, 平均風速_1950年度 <dbl>,
      #   平均風速_1949年度 <dbl>, 平均風速_1948年度 <dbl>, 平均風速_1947年度 <dbl>,
      #   平均風速_1946年度 <dbl>, 平均風速_1945年度 <dbl>, 平均風速_1944年度 <dbl>,
      #   平均風速_1943年度 <dbl>, 平均風速_1942年度 <dbl>, 平均風速_1941年度 <dbl>,
      #   平均風速_1940年度 <dbl>, 平均風速_1939年度 <dbl>, 平均風速_1938年度 <dbl>,
      #   平均風速_1937年度 <dbl>, 平均風速_1936年度 <dbl>, 平均風速_1935年度 <dbl>,
      #   平均風速_1934年度 <dbl>, 平均風速_1933年度 <dbl>, 平均風速_1932年度 <dbl>,
      #   平均風速_1931年度 <dbl>, 平均風速_1930年度 <dbl>, 平均風速_1929年度 <dbl>,
      #   平均風速_1928年度 <dbl>, 平均風速_1927年度 <dbl>, 平均風速_1926年度 <dbl>,
      #   平均風速_1925年度 <dbl>, 平均風速_1924年度 <dbl>, 平均風速_1923年度 <dbl>,
      #   平均風速_1922年度 <dbl>, 平均風速_1921年度 <dbl>, 平均風速_1920年度 <dbl>,
      #   平均風速_1919年度 <dbl>, 平均風速_1918年度 <dbl>, 平均風速_1917年度 <dbl>,
      #   平均風速_1916年度 <dbl>, 平均風速_1915年度 <dbl>, 平均風速_1914年度 <dbl>,
      #   ...
      
      $`A22-m-14_SnowDisaster_34`
      Simple feature collection with 16 features and 9 fields
      geometry type:  MULTIPOLYGON
      dimension:      XY
      bbox:           xmin: 132.0364 ymin: 34.42594 xmax: 133.3314 ymax: 35.10569
      geographic CRS: JGD2011
      # A tibble: 16 x 10
         豪雪地帯ID 地域指定時の市区町村名~ データ整備時の行政コード~ `集計単位となる団体名（雪害）~
         <chr>      <chr>            <chr>            <chr>           
       1 0010985    高宮町           34214            高宮町          
       2 0010986    美土里町         34214            美土里町        
       3 0010987    吉和村           34213            廿日市市        
       4 0010988    芸北町           34369            芸北町          
       5 0010989    戸河内町         34368            安芸太田町      
       6 0010990    千代田町         34369            千代田町        
       7 0010991    大朝町           34369            大朝町          
       8 0010992    豊平町           34369            豊平町          
       9 0010993    君田村           34209            君田村          
      10 0010994    作木村           34209            作木村          
      11 0010995    布野村           34209            布野村          
      12 0010996    口和町           34210            庄原市          
      13 0010997    高野町           34210            庄原市          
      14 0010998    西城町           34210            庄原市          
      15 0010999    東城町           34210            庄原市          
      16 0011000    比和町           34210            庄原市          
      # ... with 6 more variables: `集計単位フラグ（雪害）` <chr>,
      #   `集計単位フラグ（雪害）_code` <int>,
      #   `集計単位となる団体名（除雪ボランティア）` <chr>,
      #   `集計単位フラグ（除雪ボランティア）` <chr>,
      #   `集計単位フラグ（除雪ボランティア）_code` <int>, geometry <MULTIPOLYGON
      #   [°]>
      

---

    Code
      translateKSJData(d_A37)
    Output
      $`A37-15_PeninsulaRoadCirculation_45`
      Simple feature collection with 1 feature and 6 fields
      geometry type:  LINESTRING
      dimension:      XY
      bbox:           xmin: 131.1604 ymin: 31.45202 xmax: 131.3832 ymax: 31.54806
      geographic CRS: JGD2011
      # A tibble: 1 x 7
        指定時の路線名 半島振興対策実施地域名~ 指定時の道路種別 最大交通量 平均交通量
        <chr>          <chr>            <chr>                 <int>      <int>
      1 ２２０号       大隅             一般国道               8273       6608
      # ... with 2 more variables: `指定時の区間（住所）` <chr>, geometry <LINESTRING
      #   [°]>
      
      $`A37-15_PeninsulaRoad_45`
      Simple feature collection with 171 features and 2 fields
      geometry type:  LINESTRING
      dimension:      XY
      bbox:           xmin: 131.1656 ymin: 31.36304 xmax: 131.3871 ymax: 31.6268
      geographic CRS: JGD2011
      # A tibble: 171 x 3
         半島振興対策実施地域名~ 道路種別                                         geometry
         <chr>               <chr>                                    <LINESTRING [°]>
       1 大隅                国道       (131.3341 31.40008, 131.3341 31.40005, 131.33~
       2 大隅                国道       (131.3341 31.40008, 131.3341 31.40008, 131.33~
       3 大隅                国道       (131.344 31.40016, 131.3441 31.40023, 131.344~
       4 大隅                国道       (131.2297 31.4628, 131.2297 31.46278, 131.229~
       5 大隅                国道       (131.3728 31.53566, 131.3731 31.53492, 131.37~
       6 大隅                国道       (131.3641 31.54543, 131.3643 31.5456, 131.364~
       7 大隅                市区町村道等~ (131.334 31.36829, 131.3343 31.36824, 131.334~
       8 大隅                市区町村道等~ (131.3119 31.38912, 131.3123 31.38855, 131.31~
       9 大隅                市区町村道等~ (131.3119 31.38912, 131.3117 31.3894, 131.311~
      10 大隅                市区町村道等~ (131.3119 31.38912, 131.312 31.38922, 131.312~
      # ... with 161 more rows
      
      $`A37-15_TrafficRegulationForUnusualWeatherInPeninsula_45`
      Simple feature collection with 4 features and 8 fields
      geometry type:  MULTILINESTRING
      dimension:      XY
      bbox:           xmin: 131.1685 ymin: 31.42486 xmax: 131.3852 ymax: 31.65415
      geographic CRS: JGD2011
      # A tibble: 4 x 9
        路線名 道路種別 `規制基準雨量（連続雨量）`~ `規制基準雨量（1時間雨量）`~ `規制基準雨量（24時間雨量）~ 規制基準
        <chr>  <chr>               <int>            <int>            <int> <chr>   
      1 主要地方道~ 県道                  200         99999999         99999999 連続雨量：20~
      2 国道４４８~ 国道                  170         99999999         99999999 連続雨量：17~
      3 国道４４８~ 国道                  200         99999999         99999999 連続雨量：20~
      4 主要地方道~ 県道                  200         99999999         99999999 連続雨量：20~
      # ... with 3 more variables: `通行規制区間の起点（住所）` <chr>,
      #   `通行規制区間の終点（住所）` <chr>, geometry <MULTILINESTRING [°]>
      
      $`A37-15_PeninsulaDevelopmentTargetMunicipality_45`
      Simple feature collection with 805 features and 221 fields
      geometry type:  POLYGON
      dimension:      XY
      bbox:           xmin: 131.1598 ymin: 31.35638 xmax: 131.4253 ymax: 31.63734
      geographic CRS: JGD2011
      # A tibble: 805 x 222
         半島ID 半島振興対策実施地域名~ 市町村名 地域指定当時の市町村名~ `集計単位となる団体名（救急搬~
         <chr>  <chr>            <chr>    <chr>            <chr>           
       1 00103~ 大隅             日南市   南郷町           南郷町          
       2 00103~ 大隅             日南市   南郷町           南郷町          
       3 00103~ 大隅             日南市   南郷町           南郷町          
       4 00103~ 大隅             日南市   南郷町           南郷町          
       5 00103~ 大隅             日南市   南郷町           南郷町          
       6 00103~ 大隅             日南市   南郷町           南郷町          
       7 00103~ 大隅             日南市   南郷町           南郷町          
       8 00103~ 大隅             日南市   南郷町           南郷町          
       9 00103~ 大隅             日南市   南郷町           南郷町          
      10 00103~ 大隅             日南市   南郷町           南郷町          
      # ... with 795 more rows, and 217 more variables:
      #   データ整備時の行政コード <chr>, データ整備時の行政コード_code <chr>,
      #   `集計単位フラグ（救急搬送）` <chr>,
      #   `集計単位フラグ（救急搬送）_code` <int>, 年平均日射量 <dbl>,
      #   `平均風速（標高30m）` <dbl>, `平均風速（標高50m）` <dbl>,
      #   `平均風速（標高70m）` <dbl>, 耕作放棄地面積 <dbl>,
      #   `宿泊能力（客室数）` <int>, A37_330002 <int>, 救急車出動件数_2013年 <int>,
      #   消防防災ヘリ出動件数_2013年 <int>, 平均現場到着所要時間_2013年 <dbl>,
      #   平均病院収容時間_2013年 <dbl>, 救急車出動件数_2012年 <int>,
      #   消防防災ヘリ出動件数_2012年 <int>, 平均現場到着所要時間_2012年 <dbl>,
      #   平均病院収容時間_2012年 <dbl>, 救急車出動件数_2011年 <int>,
      #   消防防災ヘリ出動件数_2011年 <int>, 平均現場到着所要時間_2011年 <dbl>,
      #   平均病院収容時間_2011年 <dbl>, 救急車出動件数_2010年 <int>,
      #   消防防災ヘリ出動件数_2010年 <int>, 平均現場到着所要時間_2010年 <dbl>,
      #   平均病院収容時間_2010年 <dbl>, 救急車出動件数_2009年 <int>,
      #   消防防災ヘリ出動件数_2009年 <int>, 平均現場到着所要時間_2009年 <dbl>,
      #   平均病院収容時間_2009年 <dbl>, 救急車出動件数_2008年 <int>,
      #   消防防災ヘリ出動件数_2008年 <int>, 平均現場到着所要時間_2008年 <dbl>,
      #   平均病院収容時間_2008年 <dbl>, 救急車出動件数_2007年 <int>,
      #   消防防災ヘリ出動件数_2007年 <int>, 平均現場到着所要時間_2007年 <dbl>,
      #   平均病院収容時間_2007年 <dbl>, 救急車出動件数_2006年 <int>,
      #   消防防災ヘリ出動件数_2006年 <int>, 平均現場到着所要時間_2006年 <dbl>,
      #   平均病院収容時間_2006年 <dbl>, 救急車出動件数_2005年 <int>,
      #   消防防災ヘリ出動件数_2005年 <int>, 平均現場到着所要時間_2005年 <dbl>,
      #   平均病院収容時間_2005年 <dbl>, 救急車出動件数_2004年 <int>,
      #   消防防災ヘリ出動件数_2004年 <int>, 平均現場到着所要時間_2004年 <dbl>,
      #   平均病院収容時間_2004年 <dbl>, 救急車出動件数_2003年 <int>,
      #   消防防災ヘリ出動件数_2003年 <int>, 平均現場到着所要時間_2003年 <dbl>,
      #   平均病院収容時間_2003年 <dbl>, 救急車出動件数_2002年 <int>,
      #   消防防災ヘリ出動件数_2002年 <int>, 平均現場到着所要時間_2002年 <dbl>,
      #   平均病院収容時間_2002年 <dbl>, 救急車出動件数_2001年 <int>,
      #   消防防災ヘリ出動件数_2001年 <int>, 平均現場到着所要時間_2001年 <dbl>,
      #   平均病院収容時間_2001年 <dbl>, 救急車出動件数_2000年 <int>,
      #   消防防災ヘリ出動件数_2000年 <int>, 平均現場到着所要時間_2000年 <dbl>,
      #   平均病院収容時間_2000年 <dbl>, 救急車出動件数_1999年 <int>,
      #   消防防災ヘリ出動件数_1999年 <int>, 平均現場到着所要時間_1999年 <dbl>,
      #   平均病院収容時間_1999年 <dbl>, 救急車出動件数_1998年 <int>,
      #   消防防災ヘリ出動件数_1998年 <int>, 平均現場到着所要時間_1998年 <dbl>,
      #   平均病院収容時間_1998年 <dbl>, 救急車出動件数_1997年 <int>,
      #   消防防災ヘリ出動件数_1997年 <int>, 平均現場到着所要時間_1997年 <dbl>,
      #   平均病院収容時間_1997年 <dbl>, 救急車出動件数_1996年 <int>,
      #   消防防災ヘリ出動件数_1996年 <int>, 平均現場到着所要時間_1996年 <dbl>,
      #   平均病院収容時間_1996年 <dbl>, 救急車出動件数_1995年 <int>,
      #   消防防災ヘリ出動件数_1995年 <int>, 平均現場到着所要時間_1995年 <dbl>,
      #   平均病院収容時間_1995年 <dbl>, 救急車出動件数_1994年 <int>,
      #   消防防災ヘリ出動件数_1994年 <int>, 平均現場到着所要時間_1994年 <dbl>,
      #   平均病院収容時間_1994年 <dbl>, 救急車出動件数_1993年 <int>,
      #   消防防災ヘリ出動件数_1993年 <int>, 平均現場到着所要時間_1993年 <dbl>,
      #   平均病院収容時間_1993年 <dbl>, 救急車出動件数_1992年 <int>,
      #   消防防災ヘリ出動件数_1992年 <int>, 平均現場到着所要時間_1992年 <dbl>,
      #   平均病院収容時間_1992年 <dbl>, 救急車出動件数_1991年 <int>, ...
      

---

    Code
      translateKSJData(d_C02)
    Output
      $`C02-14-g_HarborDistrictBoundary`
      Simple feature collection with 1441 features and 3 fields
      geometry type:  LINESTRING
      dimension:      XY
      bbox:           xmin: 122.9931 ymin: 24.23125 xmax: 145.5942 ymax: 45.52797
      CRS:            NA
      # A tibble: 1,441 x 4
         都道府県コード 都道府県コード_code~ 港湾コード                          geometry
         <chr>          <chr>             <chr>                           <LINESTRING>
       1 北海道         01                01011      (139.5198 42.18118, 139.5277 42.~
       2 北海道         01                01014      (140.4955 42.97871, 140.4954 42.~
       3 北海道         01                01012      (140.7762 43.22544, 140.7892 43.~
       4 北海道         01                01036      (141.1637 41.82204, 141.1638 41.~
       5 北海道         01                01040      (141.1552 41.78428, 141.1551 41.~
       6 北海道         01                01004      (140.6976 41.74969, 140.6926 41.~
       7 北海道         01                01039      (140.5272 43.03034, 140.5267 43.~
       8 北海道         01                01001      (140.9309 42.33644, 140.9102 42.~
       9 北海道         01                01008      (140.5806 42.10826, 140.5804 42.~
      10 北海道         01                01009      (140.1258 41.85127, 140.1247 41.~
      # ... with 1,431 more rows
      
      $`C02-14-g_PortAndHarbor`
      Simple feature collection with 994 features and 18 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 122.9982 ymin: 24.23534 xmax: 145.5754 ymax: 45.52313
      CRS:            NA
      # A tibble: 994 x 19
         `種別（１）` `種別（１）_code`~ `種別（２）` `種別（２）_code`~ 行政区域コード
         <chr>        <chr>            <chr>        <chr>            <chr>         
       1 甲種         1                国際拠点港湾 12               北海道室蘭市  
       2 甲種         1                重要港湾     13               北海道函館市  
       3 甲種         1                重要港湾     13               北海道小樽市  
       4 乙種         2                地方港湾     14               北海道茅部郡森町~
       5 乙種         2                地方港湾     14               北海道檜山郡江差町~
       6 乙種         2                地方港湾     14               北海道久遠郡せたな町~
       7 乙種         2                地方港湾     14               北海道奥尻郡奥尻町~
       8 乙種         2                地方港湾     14               北海道余市郡余市町~
       9 乙種         2                地方港湾     14               北海道岩内郡岩内町~
      10 乙種         2                地方港湾     14               北海道松前郡松前町~
      # ... with 984 more rows, and 14 more variables: 行政区域コード_code <chr>,
      #   港湾コード <chr>, 港湾名 <chr>, 管理者区分 <chr>, 管理者区分_code <chr>,
      #   管理者名 <chr>, 政令指定年月日 <chr>, 設立年月日 <chr>,
      #   海事機関種別 <list>, 海事機関種別_code <chr>, 外郭施設延長 <chr>,
      #   係留施設延長 <chr>, フェリー便有無 <chr>, geometry <POINT>
      
      $`C02-14-g_PortDistrictBoundary`
      Simple feature collection with 520 features and 4 fields
      geometry type:  LINESTRING
      dimension:      XY
      bbox:           xmin: 124.1088 ymin: 24.32524 xmax: 145.5951 ymax: 45.46262
      CRS:            NA
      # A tibble: 520 x 5
         都道府県コード 都道府県コード_code~ `港湾・漁港コード_港湾コード~ `港湾・漁港コード_漁港コード~
         <chr>          <chr>            <chr>            <chr>           
       1 北海道         01               01001            <NA>            
       2 北海道         01               01004            1134020         
       3 北海道         01               01014            <NA>            
       4 北海道         01               01010            <NA>            
       5 北海道         01               01012            1112040         
       6 北海道         01               01009            <NA>            
       7 北海道         01               01032            <NA>            
       8 北海道         01               01008            <NA>            
       9 鹿児島県       46               46001            4920160         
      10 鹿児島県       46               46164            4930030         
      # ... with 510 more rows, and 1 more variable: geometry <LINESTRING>
      

---

    Code
      translateKSJData(d_L01)
    Output
      $`L01-20_30`
      Simple feature collection with 180 features and 134 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 135.0735 ymin: 33.47266 xmax: 136.0035 ymax: 34.36412
      geographic CRS: JGD2000
      # A tibble: 180 x 135
         標準地コード_見出し番号~ 標準地コード_見出し番号_co~ 標準地コード_一連番号~ 前年度標準地コード_見出し番号~
         <chr>            <chr>            <chr>            <chr>           
       1 住宅地           000              001              住宅地          
       2 住宅地           000              002              住宅地          
       3 住宅地           000              003              住宅地          
       4 住宅地           000              004              住宅地          
       5 住宅地           000              005              住宅地          
       6 住宅地           000              006              住宅地          
       7 住宅地           000              007              住宅地          
       8 住宅地           000              008              住宅地          
       9 住宅地           000              009              住宅地          
      10 住宅地           000              010              住宅地          
      # ... with 170 more rows, and 131 more variables:
      #   前年度標準地コード_見出し番号_code <chr>,
      #   前年度標準地コード_一連番号 <chr>, 年度 <chr>, 公示価格 <chr>,
      #   属性移動_選定状況 <chr>, 属性移動_選定状況_code <chr>,
      #   属性移動_住居漢字 <chr>, 属性移動_地積 <chr>, 属性移動_利用の現況 <chr>,
      #   属性移動_建物構造 <chr>, 属性移動_供給施設 <chr>,
      #   属性移動_駅からの距離 <chr>, 属性移動_用途区分 <chr>,
      #   属性移動_防火区分 <chr>, 属性移動_都市計画区分 <chr>,
      #   属性移動_森林区分 <chr>, 属性移動_法規制 <chr>, 属性移動_建ぺい率 <chr>,
      #   属性移動_容積率 <chr>, 標準地行政区域コード <chr>,
      #   標準地行政区域コード_code <chr>, 標準地市区町村名称 <chr>, 住居表示 <chr>,
      #   地積 <chr>, 利用現況 <chr>, 利用状況表示 <chr>, 建物構造 <chr>,
      #   `供給施設有無（水道）` <chr>, `供給施設有無（ガス）` <chr>,
      #   `供給施設有無（下水）` <chr>, 形状 <chr>, 間口比率 <chr>, 奥行比率 <chr>,
      #   地上階層 <chr>, 地下階層 <chr>, 前面道路状況 <chr>, 前面道路の方位 <chr>,
      #   前面道路の幅員 <chr>, 前面道路の駅前状況 <chr>, 前面道路の舗装状況 <chr>,
      #   側道状況 <chr>, 側道の方位 <chr>, 交通施設との近接状況 <chr>,
      #   周辺の土地利用の状況 <chr>, 駅名 <chr>, 駅からの距離 <chr>, 用途区分 <chr>,
      #   防火区分 <chr>, 都市計画区分 <chr>, 森林区分 <chr>, 公園区分 <chr>,
      #   建ぺい率 <chr>, 容積率 <chr>, 共通地点 <chr>, 選定年次ビット <chr>,
      #   調査価格_1983 <chr>, 調査価格_1984 <chr>, 調査価格_1985 <chr>,
      #   調査価格_1986 <chr>, 調査価格_1987 <chr>, 調査価格_1988 <chr>,
      #   調査価格_1989 <chr>, 調査価格_1990 <chr>, 調査価格_1991 <chr>,
      #   調査価格_1992 <chr>, 調査価格_1993 <chr>, 調査価格_1994 <chr>,
      #   調査価格_1995 <chr>, 調査価格_1996 <chr>, 調査価格_1997 <chr>,
      #   調査価格_1998 <chr>, 調査価格_1999 <chr>, 調査価格_2000 <chr>,
      #   調査価格_2001 <chr>, 調査価格_2002 <chr>, 調査価格_2003 <chr>,
      #   調査価格_2004 <chr>, 調査価格_2005 <chr>, 調査価格_2006 <chr>,
      #   調査価格_2007 <chr>, 調査価格_2008 <chr>, 調査価格_2009 <chr>,
      #   調査価格_2010 <chr>, 調査価格_2011 <chr>, 調査価格_2012 <chr>,
      #   調査価格_2013 <chr>, 調査価格_2014 <chr>, 調査価格_2015 <chr>,
      #   調査価格_2016 <chr>, 調査価格_2017 <chr>, 調査価格_2018 <chr>,
      #   調査価格_2019 <chr>, 調査価格_2020 <chr>, 属性移動_1984 <chr>,
      #   属性移動_1985 <chr>, 属性移動_1986 <chr>, 属性移動_1987 <chr>,
      #   属性移動_1988 <chr>, 属性移動_1989 <chr>, 属性移動_1990 <chr>, ...
      

---

    Code
      translateKSJData(d_N04)
    Warning <warning>
      Unknown or uninitialised column: `codelist_id`.
    Output
      $`N04_16M-4934_RoadDensityAndLengthMesh`
      Simple feature collection with 300 features and 39 fields
      geometry type:  POLYGON
      dimension:      XY
      bbox:           xmin: 134 ymin: 33.16667 xmax: 134.25 ymax: 33.33333
      CRS:            NA
      # A tibble: 300 x 40
         `3次メッシュコード`~ `3次メッシュ面積`~ `幅員13.0m（11.0m）~ `幅員13.0m（11.0m）~
         <chr>            <chr>            <chr>            <chr>           
       1 49346100         unknown          unknown          unknown         
       2 49346101         unknown          unknown          unknown         
       3 49346102         unknown          unknown          unknown         
       4 49346103         unknown          unknown          unknown         
       5 49346104         unknown          unknown          unknown         
       6 49346105         unknown          unknown          unknown         
       7 49346106         unknown          unknown          unknown         
       8 49346107         unknown          unknown          unknown         
       9 49346108         unknown          unknown          unknown         
      10 49346109         unknown          unknown          unknown         
      # ... with 290 more rows, and 36 more variables:
      #   `幅員13.0m（11.0m）以上_道路密度上_右` <chr>,
      #   `幅員13.0m（11.0m）以上_道路密度_下` <chr>,
      #   `幅員13.0m（11.0m）以上_道路延長_実延長` <chr>,
      #   `幅員13.0m（11.0m）以上_道路延長_1k㎡当り` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路密度_左` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路密度_上` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路密度上_右` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路密度_下` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路延長_実延長` <chr>,
      #   `幅員5.5m以上13.0m（11.0m）未満_道路延長_1k㎡当り` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路密度_左` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路密度_上` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路密度上_右` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路密度_下` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路延長_実延長` <chr>,
      #   `幅員3.0m（2.5m）以上5.5m未満_道路延長_1k㎡当り` <chr>,
      #   `幅員3.0m（2.5m）未満_道路密度_左` <chr>,
      #   `幅員3.0m（2.5m）未満_道路密度_上` <chr>,
      #   `幅員3.0m（2.5m）未満_道路密度上_右` <chr>,
      #   `幅員3.0m（2.5m）未満_道路密度_下` <chr>,
      #   `幅員3.0m（2.5m）未満_道路延長_実延長` <chr>,
      #   `幅員3.0m（2.5m）未満_道路延長_1k㎡当り` <chr>,
      #   `幅員（未調査）_道路密度_左` <chr>, `幅員（未調査）_道路密度_上` <chr>,
      #   `幅員（未調査）_道路密度上_右` <chr>, `幅員（未調査）_道路密度_下` <chr>,
      #   `幅員（未調査）_道路延長_実延長` <chr>,
      #   `幅員（未調査）_道路延長_1k㎡当り` <chr>, 幅員合計_道路密度_左 <chr>,
      #   幅員合計_道路密度_上 <chr>, 幅員合計_道路密度上_右 <chr>,
      #   幅員合計_道路密度_下 <chr>, 幅員合計_道路延長_実延長 <chr>,
      #   `幅員合計_道路延長_1k㎡当り` <chr>, `平面直角座標系（１９系区分）` <chr>,
      #   geometry <POLYGON>
      

---

    Code
      translateKSJData(d_P17)
    Output
      $`P17-12_29_FireStation`
      Simple feature collection with 66 features and 6 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 135.692 ymin: 33.94888 xmax: 136.1346 ymax: 34.73756
      CRS:            NA
      # A tibble: 66 x 7
         名称  行政コード 行政コード_code 種別コード 種別コード_code 所在地
         <chr> <chr>      <chr>           <chr>                <int> <chr> 
       1 奈良市消~ 奈良県奈良市~ 29201           消防本部                 1 奈良市八条~
       2 大和郡山~ 奈良県大和郡山市~ 29203           消防本部                 1 大和郡山市~
       3 山辺広域~ 奈良県天理市~ 29204           消防本部                 1 天理市田井~
       4 中和広域~ 奈良県橿原市~ 29205           消防本部                 1 橿原市慈明~
       5 桜井市消~ 奈良県桜井市~ 29206           消防本部                 1 桜井市大字~
       6 五條市消~ 奈良県五條市~ 29207           消防本部                 1 五條市本町~
       7 生駒市消~ 奈良県生駒市~ 29209           消防本部                 1 生駒市山崎~
       8 香芝・広~ 奈良県香芝市~ 29210           消防本部                 1 香芝市本町~
       9 葛城市消~ 奈良県葛城市~ 29211           消防本部                 1 葛城市中戸~
      10 宇陀広域~ 奈良県宇陀市~ 29212           消防本部                 1 宇陀市榛原~
      # ... with 56 more rows, and 1 more variable: geometry <POINT>
      
      $`P17-12_29_FireStationJurisdiction`
      Simple feature collection with 27 features and 22 fields
      geometry type:  POLYGON
      dimension:      XY
      bbox:           xmin: 135.5397 ymin: 33.85896 xmax: 136.2299 ymax: 34.78136
      CRS:            NA
      # A tibble: 27 x 23
         名称  管轄範囲1 管轄範囲2 管轄範囲3 管轄範囲4 管轄範囲5 管轄範囲6 管轄範囲7
         <chr> <chr>     <chr>     <chr>     <chr>     <chr>     <chr>     <chr>    
       1 奈良市消~ 奈良市の内　横田~ 阪原町、大平尾町~ 都祁南之庄町、都~ <NA>      <NA>      <NA>      <NA>     
       2 生駒市消~ 生駒市全域~ <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
       3 奈良市消~ 奈良市の内　奈良~ 右京四丁目、右京~ <NA>      <NA>      <NA>      <NA>      <NA>     
       4 奈良市消~ 奈良市の内　押熊~ 学園南一丁目、学~ 百楽園一丁目、百~ 登美ケ丘六丁目、~ 東登美ケ丘一丁目~ 鳥見町一丁目、鳥~ 帝塚山六丁目、帝~
       5 山辺広域~ 山添村    <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
       6 奈良市消~ 奈良市の内　三条~ 二条町三丁目、二~ 四条大路五丁目、~ 若葉台三丁目、若~ 西大寺国見町二丁~ 中町の一部、東九~ 六条緑町一丁目、~
       7 山辺広域~ 天理市    <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
       8 奈良市消~ 奈良市のうち、南~ <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
       9 大和郡山~ 大和郡山市内全域~ <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
      10 西和消防~ 平群町、三郷町、~ <NA>      <NA>      <NA>      <NA>      <NA>      <NA>     
      # ... with 17 more rows, and 15 more variables: 管轄範囲8 <chr>,
      #   管轄範囲9 <chr>, 管轄範囲10 <chr>, 管轄範囲11 <chr>, 管轄範囲12 <chr>,
      #   管轄範囲13 <chr>, 管轄範囲14 <chr>, 管轄範囲15 <chr>, 管轄範囲16 <chr>,
      #   管轄範囲17 <chr>, 管轄範囲18 <chr>, 管轄範囲19 <chr>, 管轄範囲20 <chr>,
      #   管轄範囲21 <chr>, geometry <POLYGON>
      

---

    Code
      translateKSJData(d_P21)
    Output
      $`P21-12a_15`
      Simple feature collection with 339 features and 7 fields
      geometry type:  POLYGON
      dimension:      XY
      bbox:           xmin: 137.6363 ymin: 36.78392 xmax: 139.6789 ymax: 38.54326
      CRS:            NA
      # A tibble: 339 x 8
         事業主体 事業名称 種別  種別_code 給水人口 日最大給水量 検査ID
         <chr>    <chr>    <chr>     <dbl>    <dbl>        <dbl>  <dbl>
       1 村営     内浦簡易水道事~ 簡易水道~         2        0            0      1
       2 市営     今川地区簡易水~ 簡易水道~         2        0            0      2
       3 市営     桑川地区簡易水~ 簡易水道~         2        0            0      4
       4 市営     上海府・瀬波地~ 簡易水道~         2        0            0      5
       5 市営     山辺里地区簡易~ 簡易水道~         2        0            0      6
       6 市営     第一簡易水道事~ 簡易水道~         2        0            0      7
       7 市営     第二簡易水道事~ 簡易水道~         2        0            0      8
       8 村営     釜谷簡易水道事~ 簡易水道~         2        0            0      9
       9 市営     中俣地区簡易水~ 簡易水道~         2        0            0     10
      10 市営     府屋地区簡易水~ 簡易水道~         2        0            0     11
      # ... with 329 more rows, and 1 more variable: geometry <POLYGON>
      
      $`P21-12b_15`
      Simple feature collection with 231 features and 5 fields
      geometry type:  POINT
      dimension:      XY
      bbox:           xmin: 137.732 ymin: 36.85558 xmax: 139.6741 ymax: 38.50115
      CRS:            NA
      # A tibble: 231 x 6
         事業主体 事業名称      施設名称    日最大給水量 検査ID               geometry
         <chr>    <chr>         <chr>              <dbl>  <dbl>                <POINT>
       1 市営     新井南部簡易水道事業~ 水原・泉浄水場~          360      4      (138.3279 36.984)
       2 上越市   上越市上水道事業~ 寺野浄水場           447      5    (138.3544 36.98954)
       3 市営     新井南部簡易水道事業~ 新井南浄水場~          474      6    (138.2747 36.97919)
       4 市営     平丸簡易水道事業~ 平丸浄水場            65     15     (138.325 36.94806)
       5 市営     瑞穂簡易水道事業~ 瑞穂浄水場           192     17    (138.2844 36.94888)
       6 市営     長沢簡易水道事業~ 長沢浄水場           109     18    (138.2997 36.92719)
       7 上越市   上越市上水道事業~ 和田浄水場          8500     22    (138.2618 37.05949)
       8 市営     浦川原簡易水道事業~ 小蒲生田浄水場~            8     26     (138.457 37.16713)
       9 市営     浦川原簡易水道事業~ 小谷島浄水場~         1208     29     (138.4856 37.1537)
      10 市営     牧簡易水道事業~ 牧浄水場            1196     30    (138.4359 37.03599)
      # ... with 221 more rows
      

