% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/silinfo.R
\name{silinfo}
\alias{silinfo}
\title{Compute info on silhouette widths}
\usage{
silinfo(cluster, dist)
}
\arguments{
\item{cluster}{vector with assignments of data elements to clusters}

\item{dist}{distance object or matrix}
}
\value{
list, analogous to object within output from cluster::pam.
In particular, the list has a component widths. The widths object is
matrix with one row per data item, with column sil_width holding the
silhouette width.
}
\description{
This function provides information on how well each data point
belongs to its cluster. For each query point, the function considers
the average distance to other members of the same cluster and the
average distance to members of another, nearest, cluster. The widths
are defined as the
}
\details{
The function signature is very similar to cluster::silhouette but
the implementation has important differences. This implementation
requires both the dist object and and cluster vector must have names.
This prevents accidental assignment of silhouette widths to the wrong
elements.
}
\examples{

# construct a manual clustering of the iris dataset
iris.data = iris[, 1:4]
rownames(iris.data) = paste0("iris_", seq_len(nrow(iris.data)))
iris.dist = dist(iris.data)
iris.clusters = setNames(as.integer(iris$Species), rownames(iris.data))

# compute sharpness values based on silhouette widths
silinfo(iris.clusters, iris.dist)

}
