% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktd_estimate.R
\name{ktd_estimate}
\alias{ktd_estimate}
\title{Estimate kernel Tweedie model coefficients}
\usage{
ktd_estimate(
  x,
  y,
  kern,
  lam1,
  rho = 1.5,
  ftol = 1e-08,
  partol = 1e-08,
  abstol = 0,
  maxit = 1e+06,
  sparsity = FALSE,
  lam2 = 0,
  innerpartol = 1e-06,
  innermaxit = 1e+06,
  verbose = FALSE
)
}
\arguments{
\item{x}{Covariate matrix.}

\item{y}{Outcome vector (e.g. insurance cost).}

\item{kern}{Choice of kernel. See \code{\link{dots}} for details on supported kernel functions.}

\item{lam1}{A vector of regularization coefficients.}

\item{rho}{The power parameter of the Tweedie model. Default is 1.5 and can take any real value between 1 and 2.}

\item{ftol}{Stopping criterion based on objective function value. Default is 1e-8. See Details.}

\item{partol}{Stopping criterion based on the coefficient values. Default is 1e-8. See Details.}

\item{abstol}{Stopping criterion based on absolute value of the objective function. Default is 0.}

\item{maxit}{Maximum number of iterations.}

\item{sparsity}{Logical If true, the \code{sktweedie} model with variable selection will be used. Default is false, for the \code{ktweedie} model.}

\item{lam2}{Regularization coefficient for the sparsity-inducing penalty in the \code{sktweedie} model.}

\item{innerpartol}{Stopping criterion for the inner loops that update kernel parameters and weights based on the coefficient values. See Details.}

\item{innermaxit}{Maximum number of iterations for the inner loops that update kernel parameters and variable weights. See Details.}

\item{verbose}{Logical indicating whether to show details of each update.}
}
\value{
A list of three items.
\enumerate{
\item \code{estimates}: a list containing the final objective function values and kernel Tweedie regression coefficients for each \code{lam1}.
\item \code{data}: stores the inputs, including the predictor matrix, the kernel function used in the fitting and \code{lam1}.
\item \code{sparsity}: a logical variable indicating whether the \code{ktweedie} or \code{sktweedie} is fitted.
}
}
\description{
\code{ktd_estimate()} estimates the coefficients of the kernel Tweedie model \code{ktweedie} and the sparse kernel Tweedie model \code{sktweedie}. The log of the expected Tweedie mean is modeled by a function in the reproducing kernel Hilbert space. The \code{sktweedie} has an integrated feature selection component that induces sparsity by applying weights on the features and penalizing the weights.
}
\details{
\code{ktd_estimate()} stops when the absolute difference between the objective function values of the last two updates is smaller than \code{ftol}, or the sum of absolute differences between the coefficients of the last two updates is smaller than \code{partol}, or the objective function values is below \code{abstol}, before \code{maxit} is reached. For the \code{sktweedie} model, there are inner loops for the update of kernel regression coefficients and regularization weights. The \code{innerpartol} and \code{innermaxit} arguments are the counterparts of \code{partol} and \code{maxit} for the inner loops.
}
\examples{
###### ktweedie ######
# Provide a sequence of candidate values to the argument lam1.
# Provide a kernel object to the argument kern.
lam1.seq <- c(1e-5, 1e-4, 1e-3, 1e-2, 1e-1, 1e0, 1e1)
fit.ktd <- ktd_estimate(x = dat$x, y = dat$y,
                        kern = rbfdot(sigma = 1e-8),
                        lam1 = lam1.seq)
###### sktweedie ######
# Set sparsity to TRUE and a lam2 to control the level of sparsity
# Decrease lam2 if "WARNING: All weights are zero..."
fit.sktd <- ktd_estimate(x = dat$x,
                         y = dat$y,
                         kern = rbfdot(sigma = 0.1),
                         lam1 = 5,
                         sparsity = TRUE,
                         lam2 = 1)
# variables with fitted weight equal to 0 are not selected

}
\seealso{
\code{\link{ktd_cv}}, \code{\link{ktd_cv2d}}, \code{\link{ktd_predict}}, \code{\link{rbfdot}}
}
