% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{as.data.frame.kuzu.query_result.QueryResult}
\alias{as.data.frame.kuzu.query_result.QueryResult}
\title{Convert a Kuzu Query Result to a Data Frame}
\usage{
\method{as.data.frame}{kuzu.query_result.QueryResult}(x, ...)
}
\arguments{
\item{x}{A Kuzu query result object.}

\item{...}{Additional arguments passed to \code{as.data.frame}.}
}
\value{
An R \code{data.frame} containing the query results.
}
\description{
Provides an S3 method to seamlessly convert a Kuzu query result object into a
standard R \code{data.frame}.
}
\examples{
\donttest{
conn <- kuzu_connection(":memory:")
kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64,
PRIMARY KEY (name))")
kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")
result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")

# Convert the result to a data.frame
df <- as.data.frame(result)
print(df)
}
}
