% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounding_box.R
\name{bounding_box}
\alias{bounding_box}
\alias{bounding_box.default}
\alias{bounding_box.lac_voxels}
\alias{bounding_box.lasmetrics3d}
\title{Create voxel array}
\usage{
bounding_box(x, threshold = 0, edge_length = NULL)
}
\arguments{
\item{x}{A '\code{lac_voxels}' object created by \code{\link[=voxelize]{voxelize()}} (preferred), or a
'\code{lasmetrics3d}' object created by \code{\link[lidR:aggregate]{lidR::voxel_metrics()}}. Users can
alternatively supply a \code{\link[data.table:data.table]{data.table::data.table()}} containing X, Y, Z,
and N columns, in which case the argument \code{edge_length} is required.}

\item{threshold}{An integer specifying the minimum number of points to use
when determining if a voxel is occupied. The default is \code{0}.
\code{bounding_box()} retains only those voxels where \code{x$N} is greater than
\code{threshold}.}

\item{edge_length}{a numeric vector of length 3, specifying the X, Y, and Z
dimensions of each voxel. This argument should only be necessary when
supplying voxel data generated by a function other than \code{\link[=voxelize]{voxelize()}} or
\code{\link[lidR:aggregate]{lidR::voxel_metrics()}}.}
}
\value{
A 3-dimensional integer \code{\link[=array]{array}} containing values of \code{0}
or \code{1}, representing the occupancy of a given voxel. Occupied voxels (\code{1})
are arranged according to their relative positions in 3-dimensional space,
and fully encapsulated within a rectangular volume of unoccupied voxels
(\code{0}). The XYZ positions of the voxels are retained in the array
\code{\link[=dimnames]{dimnames}}.
}
\description{
\code{bounding_box()} takes a table of voxel data and converts it into a
3-dimensional array, with the original voxels arranged in their correct
spatial positions inside of a 3-D "box" of empty voxels. This array can be
input directly into \code{\link[=lacunarity]{lacunarity()}} to generate lacunarity curves.
}
\details{
\code{bounding_box()} relies on the spatial coordinates of the input data
to determine the dimensions of the resulting array. Noisy point cloud data
will often produce "outlier" voxels surrounding points that are far removed
from the bulk of the point cloud. These can drastically alter the output,
creating an array in which the occupied voxels are surrounded by a large
region of empty space. It is highly recommended that users supply a cutoff
value for \code{threshold} to ideally remove these outliers. More elaborate
filtering tools for trimming the point data before voxelization are
available in the \code{\link[lidR:lidR-package]{lidR}} package.
}
\examples{
# Basic usage ---------------------------------------------------------------
# simulate a diagonal line of points with XYZ coordinates
pc <- data.frame(X = as.numeric(0:24), 
                 Y = as.numeric(0:24), 
                 Z = as.numeric(0:24))
# convert point data to cubic voxels of length 5
vox <- voxelize(pc, edge_length = c(5,5,5))
# convert to voxel array
box <- bounding_box(vox)

# Using lidR::voxel_metrics -------------------------------------------------
\donttest{if (require("lidR")){
# reformat point data into rudimentary LAS object
las <- suppressMessages(lidR::LAS(pc))
# convert to voxels of length 5
vox <- lidR::voxel_metrics(las, ~list(N = length(Z)), res = 5)
# convert to voxel array
box <- bounding_box(vox)
}
}
}
