% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_metadata.R
\name{get_metadata}
\alias{get_metadata}
\title{get metadata for a lake in GLTC dataset}
\usage{
get_metadata(lake_name, metadata_name)
}
\arguments{
\item{lake_name}{a valid name of a lake in the GLTC dataset (see \code{\link{get_lake_names}}).
\code{lake_name} is case insensitive.}

\item{metadata_name}{a name of a metadata variable in GLTC dataset
(optional; see \code{\link{get_metadata_names}}).
\code{metadata_name} is case insensitive.}
}
\value{
data.frame with metadata (if \code{metadata_name} is missing) or the value of that metadata field if
\code{metadata_name} is specified
}
\description{
Find associated metadata for a lake from the Global Lake Temperature Collaboration dataset.
See associated publication and references therein for details including units and data provenance.
}
\examples{
get_metadata('Victoria','Sampling.depth')
get_metadata('Mendota')
get_metadata('mendota','sampling.depth')
get_metadata("Toolik.JJA",c('location','source'))
}
\seealso{
\code{\link{get_metadata_names}}, \code{\link{get_lake_names}}, \code{\link{get_climate_names}}
}

