% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadGene}
\alias{loadGene}
\title{Load a gene}
\usage{
loadGene(name, type = "majorGene")
}
\arguments{
\item{name}{name of the gene}

\item{type}{type of the gene: "majorGene", "APR", "QTL" or "immunity" (default = "majorGene")}
}
\value{
a data.frame with gene parameters
}
\description{
Creates a data.frame containing parameters of a gene depending of his type
}
\details{
\itemize{
\item "majorGene" means a completely efficient gene that can be broken down via a single
pathogen mutation
\item "APR" means a major gene that is active only after a delay of 30 days after planting
\item "QTL" means a partial resistance (50\% efficiency) that requires several pathogen mutations
to be completely eroded
\item "immunity" means a completely efficient resistance that the pathogen has no way to adapt
(i.e. the cultivar is non-host).
}

For different scenarios, the data.frame can be manually updated later.
}
\examples{
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene1
gene2 <- loadGene(name = "Lr34", type = "APR")
gene2
}
\seealso{
\link{setGenes}
}
