% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R
\name{spillover}
\alias{spillover}
\title{Inference on Average Spillover Effect Parameters}
\usage{
spillover(
  Y,
  D,
  Z,
  IEM,
  S,
  A,
  K = 1,
  z,
  t0,
  t1,
  bw = NULL,
  B = NULL,
  alp = 0.05
)
}
\arguments{
\item{Y}{An n-dimensional outcome vector}

\item{D}{An n-dimensional binary treatment vector}

\item{Z}{An n-dimensional binary instrumental vector}

\item{IEM}{An n-dimensional instrumental exposure vector}

\item{S}{An n-dimensional logical vector to indicate whether each unit
belongs to the sub-population S}

\item{A}{An n times n symmetric binary adjacency matrix}

\item{K}{A scalar to indicate the range of neighborhood
used for constructing the interference set.
Default is 1.
In the \code{spillover()} function, \code{K} is used only for computing the bandwidth.}

\item{z}{A scalar of the evaluation point of Z}

\item{t0}{A scalar of the evaluation point of instrumental exposure (from)}

\item{t1}{A scalar of the evaluation point of instrumental exposure (to)}

\item{bw}{A scalar of the bandwidth used for the HAC estimation and
the wild bootstrap.
If \code{bw = NULL}, the rule-of-thumb bandwidth proposed by Leung (2022) is used.
Default is NULL.}

\item{B}{The number of bootstrap repetitions.
If \code{B = NULL}, wild bootstrap is skipped.
Default is NULL.}

\item{alp}{The significance level.
Default is 0.05.}
}
\value{
A data frame containing the following elements:
\item{est}{The parameter estimate}
\item{HAC_SE}{The standard error computed by the network HAC estimation}
\item{HAC_CI_L}{The lower bound of the confidence interval computed by
the network HAC estimation}
\item{HAC_CI_U}{The upper bound of the confidence interval computed by
the network HAC estimation}
\item{wild_SE}{The standard error computed by the wild bootstrap}
\item{wild_CI_L}{The lower bound of the confidence interval computed by
the wild bootstrap}
\item{wild_CI_U}{The upper bound of the confidence interval computed by
the wild bootstrap}
\item{bw}{The bandwidth used for the HAC estimation
and the wild bootstrap}
\item{size}{The size of the subpopulation S}
}
\description{
Inference on the average spillover effect of the IV on the outcome,
that on the treatment receipt, and the local average spillover effect
in the presence of network spillover of unknown form
}
\details{
The \code{spillover()} function estimates the average spillover effect of the IV
on the outcome, that on the treatment receipt,
and the local average spillover effect via inverse probability weighting
in the approximate neighborhood interference framework.
The function also computes the standard errors and the confidence intervals
for the target parameters based on the network HAC estimation and
the wild bootstrap.
For more details, see Hoshino and Yanagi (2023).
The lengths of \code{Y}, \code{D}, \code{Z}, \code{IEM}, \code{S} and
of the row and column of \code{A} must be the same.
\code{z} must be 0 or 1.
\code{t0} and \code{t1} must be values in the support of \code{IEM}.
\code{bw} must be \code{NULL} or a non-negative number.
\code{B} must be \code{NULL} or a positive integer.
\code{alp} must be a positive number between 0 and 0.5.
}
\examples{
# Generate artificial data
set.seed(1)
n <- 2000
data <- latenetwork::datageneration(n = n)

# Arguments
Y   <- data$Y
D   <- data$D
Z   <- data$Z
S   <- rep(TRUE, n)
A   <- data$A
K   <- 1
IEM <- ifelse(A \%*\% Z > 0, 1, 0)
z   <- 1
t0  <- 0
t1  <- 1
bw  <- NULL
B   <- NULL
alp <- 0.05

# Estimation
latenetwork::spillover(Y = Y,
                       D = D,
                       Z = Z,
                       IEM = IEM,
                       S = S,
                       A = A,
                       K = K,
                       z = z,
                       t0 = t0,
                       t1 = t1,
                       bw = bw,
                       B = B,
                       alp = alp)

}
\references{
Hoshino, T., & Yanagi, T. (2023).
Causal inference with noncompliance and unknown interference.
arXiv preprint arXiv:2108.07455.

Leung, M.P. (2022).
Causal inference under approximate neighborhood interference.
Econometrica, 90(1), pp.267-293.
}
