% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/model.R
\name{plotFittedTrajectories}
\alias{plotFittedTrajectories}
\alias{plotFittedTrajectories,lcModel-method}
\title{Plot the fitted trajectories}
\usage{
plotFittedTrajectories(object, ...)

\S4method{plotFittedTrajectories}{lcModel}(object, ...)
}
\arguments{
\item{object}{The model.}

\item{...}{Arguments passed to \code{\link[=fittedTrajectories]{fittedTrajectories()}} and \link{plotTrajectories}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the fitted trajectories as represented by the given model
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plotFittedTrajectories(model)
}
}
\seealso{
\link{fittedTrajectories}

\link{plotClusterTrajectories} \link{plotTrajectories} \link{plot}

Other lcModel functions: 
\code{\link{clusterNames}()},
\code{\link{clusterProportions}()},
\code{\link{clusterSizes}()},
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{estimationTime}()},
\code{\link{externalMetric}()},
\code{\link{fitted.lcModel}()},
\code{\link{fittedTrajectories}()},
\code{\link{getCall.lcModel}()},
\code{\link{getLcMethod}()},
\code{\link{ids}()},
\code{\link{lcModel-class}},
\code{\link{metric}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nClusters}()},
\code{\link{nIds}()},
\code{\link{nobs.lcModel}()},
\code{\link{plot-lcModel-method}},
\code{\link{plotClusterTrajectories}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{qqPlot}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{strip}()},
\code{\link{time.lcModel}()},
\code{\link{trajectoryAssignments}()}
}
\concept{lcModel functions}
