% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool-modindices.R
\name{modindices.mi}
\alias{modindices.mi}
\alias{modificationIndices.mi}
\alias{modificationindices.mi}
\title{Modification Indices for Multiple Imputations}
\usage{
modindices.mi(
  object,
  pool.method = c("D2", "D1"),
  omit.imps = c("no.conv", "no.se"),
  standardized = TRUE,
  cov.std = TRUE,
  information = "expected",
  power = FALSE,
  delta = 0.1,
  alpha = 0.05,
  high.power = 0.75,
  sort. = FALSE,
  minimum.value = 0,
  maximum.number = nrow(LIST),
  na.remove = TRUE,
  op = NULL
)

modificationIndices.mi(
  object,
  pool.method = c("D2", "D1"),
  omit.imps = c("no.conv", "no.se"),
  standardized = TRUE,
  cov.std = TRUE,
  information = "expected",
  power = FALSE,
  delta = 0.1,
  alpha = 0.05,
  high.power = 0.75,
  sort. = FALSE,
  minimum.value = 0,
  maximum.number = nrow(LIST),
  na.remove = TRUE,
  op = NULL
)

modificationindices.mi(
  object,
  pool.method = c("D2", "D1"),
  omit.imps = c("no.conv", "no.se"),
  standardized = TRUE,
  cov.std = TRUE,
  information = "expected",
  power = FALSE,
  delta = 0.1,
  alpha = 0.05,
  high.power = 0.75,
  sort. = FALSE,
  minimum.value = 0,
  maximum.number = nrow(LIST),
  na.remove = TRUE,
  op = NULL
)
}
\arguments{
\item{object}{An object of class \linkS4class{lavaan.mi}}

\item{pool.method}{\code{character} indicating which pooling method to use.
\code{"D1"} requests Mansolf, Jorgensen, & Enders' (2020) proposed
Wald-like test for pooling the gradient and information, which are then
used to calculate score-test statistics in the usual manner. \code{"D2"}
(default because it is less computationally intensive) requests to pool the
complete-data score-test statistics from each imputed data set, then pool
them across imputations, described by Li et al. (1991) and Enders (2010).}

\item{omit.imps}{\code{character} vector specifying criteria for omitting
imputations from pooled results.  Can include any of
\code{c("no.conv", "no.se", "no.npd")}, the first 2 of which are the
default setting, which excludes any imputations that did not
converge or for which standard errors could not be computed.  The
last option (\code{"no.npd"}) would exclude any imputations which
yielded a nonpositive definite covariance matrix for observed or
latent variables, which would include any "improper solutions" such
as Heywood cases. Specific imputation numbers can also be included in this
argument, in case users want to  apply their own custom omission criteria
(or simulations can use different numbers of imputations without
redundantly refitting the model).}

\item{standardized}{\code{logical}. If \code{TRUE}, two extra columns
(\verb{$sepc.lv} and \verb{$sepc.all}) will contain standardized values
for the EPCs. In the first column (\verb{$sepc.lv}), standardizization is
based on the variances of the (continuous) latent variables. In the second
column (\verb{$sepc.all}), standardization is based on both the variances
of both (continuous) observed and latent variables. (Residual) covariances
are standardized using (residual) variances.}

\item{cov.std}{\code{logical}. \code{TRUE} if \code{pool.method == "D2"}.
If \code{TRUE} (default), the (residual)
observed covariances are scaled by the square-root of the diagonal elements
of the \eqn{\Theta} matrix, and the (residual) latent covariances are
scaled by the square-root of the diagonal elements of the \eqn{\Psi}
matrix. If \code{FALSE}, the (residual) observed covariances are scaled by
the square-root of the diagonal elements of the model-implied covariance
matrix of observed variables (\eqn{\Sigma}), and the (residual) latent
covariances are scaled by the square-root of the diagonal elements of the
model-implied covariance matrix of the latent variables.}

\item{information}{\code{character} indicating the type of information
matrix to use (check \code{\link[lavaan:lavInspect]{lavaan::lavInspect()}} for available options).
\code{"expected"} information is the default, which provides better
control of Type I errors.}

\item{power}{\code{logical}. If \code{TRUE}, the (post-hoc) power is
computed for each modification index, using the values of \code{delta}
and \code{alpha}.}

\item{delta}{The value of the effect size, as used in the post-hoc power
computation, currently using the unstandardized metric of the \verb{$epc}
column.}

\item{alpha}{The significance level used for deciding if the modification
index is statistically significant or not.}

\item{high.power}{If the computed power is higher than this cutoff value,
the power is considered 'high'. If not, the power is considered 'low'.
This affects the values in the \verb{$decision} column in the output.}

\item{sort.}{\code{logical}. If \code{TRUE}, sort the output using the
values of the modification index values. Higher values appear first.}

\item{minimum.value}{\code{numeric}. Filter output and only show rows with a
modification index value equal or higher than this minimum value.}

\item{maximum.number}{\code{integer}. Filter output and only show the first
maximum number rows. Most useful when combined with the \code{sort.} option.}

\item{na.remove}{\code{logical}. If \code{TRUE} (default), filter output by
removing all rows with \code{NA} values for the modification indices.}

\item{op}{\code{character} string. Filter the output by selecting only those
rows with operator \code{op}.}
}
\value{
A \code{data.frame} containing modification indices and (S)EPCs.
}
\description{
Modification indices (1-\emph{df} Lagrange multiplier tests) from a
latent variable model fitted to multiple imputed data sets. Statistics
for releasing one or more fixed or constrained parameters in model can
be calculated by pooling the gradient and information matrices
across imputed data sets in a method proposed by Mansolf, Jorgensen, &
Enders (2020)---analogous to the "D1" Wald test proposed by Li, Meng,
Raghunathan, & Rubin (1991)---or by pooling the complete-data score-test
statistics across imputed data sets (i.e., "D2"; Li et al., 1991).
}
\note{
When \code{pool.method = "D2"}, each (S)EPC will be pooled by taking its
average across imputations. When \code{pool.method = "D1"}, EPCs will be
calculated in the standard way using the pooled gradient and information,
and SEPCs will be calculated by standardizing the EPCs using model-implied
(residual) variances.
}
\examples{
data(HS20imps) # import a list of 20 imputed data sets

## specify CFA model from lavaan's ?cfa help page
HS.model <- '
  visual  =~ x1 + x2 + x3
  textual =~ x4 + x5 + x6
  speed   =~ x7 + x8 + x9
'

fit <- cfa.mi(HS.model, data = HS20imps)

modindices.mi(fit) # default: Li et al.'s (1991) "D2" method

## Li et al.'s (1991) "D1" method,
## adapted for score tests by Mansolf et al. (2020)
modindices.mi(fit, pool.method = "D1")


}
\references{
Enders, C. K. (2010). \emph{Applied missing data analysis}.
New York, NY: Guilford.

Li, K.-H., Meng, X.-L., Raghunathan, T. E., & Rubin, D. B. (1991).
Significance levels from repeated \emph{p}-values with multiply-imputed
data.\emph{Statistica Sinica, 1}(1), 65--92. Retrieved from
\url{https://www.jstor.org/stable/24303994}

Mansolf, M., Jorgensen, T. D., & Enders, C. K. (2020). A multiple
imputation score test for model modification in structural equation
models. \emph{Psychological Methods, 25}(4), 393--411.
\doi{10.1037/met0000243}
}
\seealso{
\code{\link[=lavTestScore.mi]{lavTestScore.mi()}}
}
\author{
Terrence D. Jorgensen (University of Amsterdam; \email{TJorgensen314@gmail.com})

Based on source code for \code{\link[lavaan:modificationIndices]{lavaan::modindices()}} by Yves Rosseel

\code{pool.method = "D1"} method proposed by
Maxwell Mansolf (University of California, Los Angeles;
\email{mamansolf@gmail.com})
}
