% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcpm.R
\name{lcpm}
\alias{lcpm}
\title{Fitting a Log Cumulative Probability Model}
\usage{
lcpm(
  formula.linear,
  data,
  conf.level = 0.95,
  y.order = NULL,
  startval = NULL,
  less.than.0 = TRUE,
  control.list = NULL,
  eps.outer = NULL,
  ...
)
}
\arguments{
\item{formula.linear}{an object of class "formula": a symbolic description of the linear model to be fitted.}

\item{data}{dataframe containing the data in linear model.}

\item{conf.level}{optional confidence level (1-alpha) defaulted to 0.95.}

\item{y.order}{optional if y contains ordered integer categories 1:J. If y is not ordered integer 1:J then this is a vector with the ordinal values for y ranging from the lowest to largest ordinal outcome. See Examples below.}

\item{startval}{optional vector of the starting values.}

\item{less.than.0}{optional logical for constraint cut_j <= 0 for all j=1:(J-1). Default is TRUE.}

\item{control.list}{optional list of controls for constrOptim}

\item{eps.outer}{option for constrOptim}

\item{...}{Additional arguments for built in functions}
}
\value{
list of class "lcpm" is returned containing:
\item{coefficients}{vector of the estimate of cut_j and beta_j}
\item{se}{vector of the estimate of standard errors}
\item{vcov}{matrix of the inverse of the negative Hessian}
\item{fitted.values}{matrix of unique covariates and the corresponding estimate of the cumulative probabilities: exp(X \%*\% coefficients)}
\item{loglik}{numerical value of the log-likelihood at the maximum likelihood estimate}
\item{barrier.value}{value of mu in the log-barrier algorithm}
\item{outer.iterations}{value of the number of outer iterations}
\item{formula}{formula in the call of lcpm}
\item{startvalues}{vector of the starting values for constrained optimization algorithm}
\item{proptest}{Score test if a proportionality assumption is appropriate, includes test statistic (teststat), p-value (pval), df, and fitted proportional probability model (propmodel)}
}
\description{
\code{lcpm} provides the maximum likelihood estimate for ordinal outcomes (J>2 categories) and a Generalized Linear Model (GLM) with the log link without the assumption of proportionality. That is, lcpm determines the MLE for log[P(y <= j)]= cut_j + X beta_j subject to [cut_{j-1} + X beta_{j-1} <= cut_j + X beta_j] and [cut_j + X beta_j <=0]. This implementation uses \code{\link{constrOptim}}  to determine the MLE and so the results account for the restricted parameter space.
}
\note{
A warning of MLE close to the boundary must be carefully considered. Data may have some structure that requires attention. Additionally, there is no imputation. Any NA results in complete row removal.
}
\examples{
# Example below showing the use of y.order if outcome is not integers 1:J.
# See examples in ppm for an additional example


var_a <- c(rep(0,60),rep(1,60))
var_b <- c(rep(0,90),rep(1,30))
y1<-c(rep(2,5),rep(3,10),rep(5,5),rep(10,10),
rep(2,5),rep(3,10),rep(5,10),rep(10,5),
rep(2,10),rep(3,5),rep(5,5),rep(10,10),
rep(2,10),rep(3,5),rep(5,10),rep(10,5))

testdata<-data.frame(y=y1,var_a=var_a,var_b=var_b)

# LCPM estimates for non-proportional model
test1<-lcpm(y ~ var_a + var_b, data=testdata, y.order=c(2,3,5,10))
summary(test1)

# The proportional probability model used for the score test
summary(test1$proptest$propmodel)
}
\references{
Singh, G; Fick, G.H. Ordinal outcomes: a cumulative probability model with the log link without an assumption of proportionality. Manuscript in preparation.
}
\seealso{
\code{\link{ppm}}
}
