% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_heuristic2.R
\name{.choose_best_test_statistic}
\alias{.choose_best_test_statistic}
\title{Chooses rows with best test statistic.}
\usage{
.choose_best_test_statistic(
  dat,
  condition,
  covariates,
  halting_test,
  thresh,
  tiebreaker
)
}
\arguments{
\item{dat}{A data.table with an ind column with indices for items to
consider dropping.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{thresh}{The return value of halting_test has to be greater than
or equal to thresh for the matched groups.}

\item{tiebreaker}{NULL, or a function similar to halting_test, used to
decide between cases for which halting_test yields
equal values.}
}
\value{
A data.table containing only the rows of dat with for best test
        statistic values (decided primarily by halting_test, then by
        tiebreaker).
}
\description{
Chooses rows with best test statistic.
}
\keyword{internal}
