#' Leaf and pseudobulb angles of epiphytic orchids
#'
#' The \code{orchids} data.frame has 500 rows and 7 columns
#' @format This data.frame contains the following columns:
#'
#' 		\strong{measure.ID} Number of observation (from Ahmes).
#'
#' 		\strong{orchid.ID} Identification of the orchid.
#'
#' 		\strong{organ} Tags each observation with "leaf" or "pseudobulb".
#'
#' 		\strong{module} Identifies the leaf-pseudobulb pair.
#'
#'		\strong{pitch} Pitch angle in degrees.
#'
#' 		\strong{roll} Roll angle in degrees.
#'
#' 		\strong{course} Course angle in degrees.
#'
#' @details Subset of the dataset in Ventre-Lespiaucq et al. (2017). These data are measurements of three leaf position angles of 250 leaf-pseudobulb pairs in 84 epiphytic orchids (\emph{Rodriguezia granadensis}). Each row contains either pseudobulb or leaf angle data.
#' @references \code{orchids} \strong{Ventre-Lespiaucq, A., Delgado, J.A., Ospina-Calderon, N.H., Otero, J.T., Escudero, A., Sanchez, M.A., Balaguer, L., Flanagan, N.S. (2017)} A tropical epiphytic orchid uses a low-light interception strategy in a spatially heterogeneous light environment. Biotropica 49:318-327. doi:10.1111/btp.12425.
#' @references \strong{Ahmes 1.0} \url{https://play.google.com/store/apps/details?id=com.movil.hoja.movihoja.ahmes&hl=en}
#' @references \strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014)} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.
"orchids"

