% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star.app.R
\name{star.app}
\alias{star.app}
\title{Calculate the silhouette to area ratio from 'Ahmes' 1.0}
\usage{
star.app(x, lat, long, tz)
}
\arguments{
\item{x}{Output of 'Ahmes' 1.0, a .csv file.}

\item{lat}{A vector with the latitude of each observation in decimal format. If all observations correspond to the same latitude, \code{lat} can be introduced directly as a single number (see examples).}

\item{long}{A vector with the longitude of each observation in decimal format. If all observations correspond to the same longitude, \code{long} can be introduced directly as a single number (see examples).}

\item{tz}{A vector with the time zone of each observation. If all observations correspond to the same time zone, \code{tz} can be introduced directly as a single number. Time zones located at the West of Greenwich are negative, and at the East are positive; e.g., for Colombia, \code{tz} = -5; for Reunion Island, \code{tz} = 4.}
}
\description{
This is a version of \code{star()} function that only works with the output of 'Ahmes' 1.0. This function calculates the percentage of potential exposure of flat, tilted surfaces to direct solar radiation. It is equivalent to the ratio of the surface projected area to total surface area, but instead of using area data it uses spatial position angles (pitch, roll and course or tilt and course), geographical coordinates, hour and date information. This function implements equation 3 in Escribano-Rocafort et al. (2014).
}
\details{
This function calls \code{\link{fixfile}} internally before calculating STAR. However, it does not modify the original dataset. To have a permanent fixed version of the data, use \code{new.file<-fixfile(your.data)}. If using \code{new.file} within the package, be aware that the argument \code{Ahmes} should be set to \code{FALSE}.
}
\examples{
\donttest{data(olea)
  starapp_olea<-star.app(olea,lat=40,long=4,tz=2)

 ## Add results to the original dataset
  olea1<-fixfile(olea) ## Fix the original dataset
  olea2<-cbind(olea1,as.data.frame(starapp_olea))}

#star.app()
}
\references{
\strong{Escribano-Rocafort, A.G., Ventre-Lespiaucq, A.B., Granado-Yela, C., Lopez-Pintor, A., Delgado, J.A., Munoz, V., Dorado, G.A., Balaguer, L. (2014).} Simplifying data acquisition in plant canopies- Measurements of leaf angles with a cell phone. Methods in Ecology and Evolution 5:132-140. doi:10.1111/2041-210X.12141.
}
\seealso{
\code{\link{fixfile}}, \code{\link{star}}, \code{\link{simu.star.app}}
}
\author{
Agustina Ventre-Lespiaucq and Silvia Santamaria Bueno.
}
\keyword{'Ahmes'}
\keyword{star}
