% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{leakr_audit}
\alias{leakr_audit}
\title{Audit dataset for data leakage}
\usage{
leakr_audit(
  data,
  target = NULL,
  split = NULL,
  id = NULL,
  detectors = NULL,
  config = list()
)
}
\arguments{
\item{data}{The dataset to be audited (data frame or tibble).}

\item{target}{The target variable (optional). If NULL, no target variable is assumed.}

\item{split}{The split variable used for training/test split (optional). If NULL, no split is assumed.}

\item{id}{The unique identifier for each row (optional). If NULL, no id is used.}

\item{detectors}{A vector of detector names to run (optional). If NULL, all available detectors will be used.}

\item{config}{A list of configuration parameters for the audit. Defaults to an empty list.}
}
\value{
A \code{leakr_report} object containing the audit results, including summary, evidence, and metadata.
}
\description{
This function audits a dataset for potential data leakage, running a series of predefined detectors
and generating a comprehensive report with detailed findings.
}
\examples{
\donttest{
# Basic audit on iris dataset
report <- leakr_audit(iris, target = "Species")
print(report)
}

}
