% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantile.R
\name{Q}
\alias{Q}
\title{Quantile distribution function.}
\usage{
Q(
  p,
  dist = "normal",
  lower.tail = TRUE,
  two.sided = FALSE,
  rounding = 2,
  gui = "plot",
  mfrow = c(1, 2),
  type = "both",
  ...
)
}
\arguments{
\item{p}{probability. The \code{p} argument need have length 1 and value lower then 1.}

\item{dist}{distribution to use. The default is \code{'normal'}. Options: \code{'normal'}, \code{'t-student'}, \code{'gumbel'}, \code{'binomial'}, \code{'poisson'}, and ....}

\item{lower.tail}{logical; if \code{TRUE} (default), the quantile function is computed; otherwise, the complement of the quantile function (survival function) will be computed. The \code{lower.tail} argument will only be valid for two-\code{sided = FALSE}.}

\item{two.sided}{logical. if \code{TRUE} (default), the calculation of the quantile function and survival will be presented; otherwise the \code{Q()} function will be based according to the \code{lower.tail} argument.}

\item{rounding}{numerical; it represents the number of decimals for calculating the probability.}

\item{gui}{default is \code{'plot'}; it graphically displays the result of the probability. Others options are: \code{"plot"} and \code{"rstudio"} and \code{"tcltk"}.}

\item{mfrow}{numerical vector. Considering the arguments \code{two.sided = TRUE} and \code{type = "both"}, the default will be to present two graphs (based on CDF and PDF) horizontally for the quantile function, that is, \code{mfrow = c(1, 2)} (default).}

\item{type}{character argument. The default is \code{"both"}; the output will display two plots (based on CDF and PDF) to present the result of Q(). The other options are: \code{"cdf"} and \code{"pdf"}.}

\item{...}{additional parameters according to the chosen distribution.}
}
\value{
\code{Q} returns the quantile and its graphical representation for a given distribution. The output is a vector.
}
\description{
\code{Q} Quantile function for multiple distributions.
}
\details{
The expression of quantile function is given by:
\deqn{
Q(p)=\inf {x\in \mathbb{R}: p \le F(x)},
}
where \code{p} is the first argument of \code{Q()} and \code{x} its return value;
}
\examples{
# Attaching package
library(leem)
\dontrun{
Q(p = 0.8, dist = "normal", mean = 200, sd=30)
}
}
