% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isFunctions.R
\name{is.legion}
\alias{is.legion}
\alias{is.oves}
\alias{is.legion.sim}
\title{legion classes checkers}
\usage{
is.legion(x)

is.oves(x)

is.legion.sim(x)
}
\arguments{
\item{x}{The object to check.}
}
\value{
\code{TRUE} if this is the specified class and \code{FALSE} otherwise.
}
\description{
Functions to check if an object is of the specified class
}
\details{
The list of methods includes:
\itemize{
\item \code{is.legion()} tests if the object was produced by a vector model (e.g.
\link[legion]{ves});
\item \code{is.oves()} tests if the object was produced by \link[legion]{oves}
function;
\item \code{is.legion.sim()} tests if the object was produced by the functions
\link[legion]{sim.ves};
}
}
\examples{

\donttest{ourModel <- ves(cbind(rnorm(100,100,10),rnorm(100,100,10)))
is.legion(ourModel)}

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{ts}
\keyword{univar}
