% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_core.R
\name{get_core}
\alias{get_core}
\title{Fetch 'Core' table}
\format{
Data frame with columns (varies by legislature):
\itemize{
\item{country: ISO 3166-1 alpha-3 three-letter country code (of class \sQuote{character}).}
\item{pageid: Wikipedia page ID identifying a legislator's Wikipedia biography (of class \sQuote{integer} or \sQuote{character}).}
\item{wikidataid: Wikidata ID identifying a legislator's Wikidata entry (of class \sQuote{character}).}
\item{wikititle: A legislator's undirected Wikipedia title (of class \sQuote{character}).}
\item{name: A legislator's full name (of class \sQuote{character}).}
\item{sex: A legislator's sex (of class \sQuote{character}).}
\item{ethnicity: A legislator's ethnicity (of class \sQuote{character}).}
\item{religion: A legislator's religious denomination (of class \sQuote{character}).}
\item{birth: A legislator's date of birth (of class \sQuote{POSIXct}).}
\item{death: A legislator's date of death (of class \sQuote{POSIXct}).}
\item{birthplace: Comma separated latitude and longitude of a legislator's place of birth (of class \sQuote{character}).}
\item{deathplace: Comma separated latitude and longitude of a legislator's place of death (of class \sQuote{character}).}
}
}
\source{
Wikipedia, \url{https://www.wikipedia.org/} \cr
Wikipedia API, \url{https://en.wikipedia.org/w/api.php} \cr
Wikidata API, \url{https://www.wikidata.org/wiki/Wikidata:Main_Page} \cr
Wikimedia Commons, \url{https://commons.wikimedia.org/wiki/Main_Page} \cr
Face++ Cognitive Services API, \url{https://www.faceplusplus.com/} \cr
Germany Bundestag Open Data, \url{https://www.bundestag.de/services/opendata}
}
\usage{
get_core(legislature)
}
\arguments{
\item{legislature}{A character string specifying the three-letter country code of the legislature for which data shall be fetched. Currently one of \sQuote{aut}, \sQuote{can}, \sQuote{cze}, \sQuote{esp}, \sQuote{fra}, \sQuote{deu}, \sQuote{irl}, \sQuote{sco}, \sQuote{gbr}, \sQuote{usa_house}, or \sQuote{usa_senate}.}
}
\value{
A data frame with columns as specified above.
}
\description{
Fetches sociodemographic data of legislators for the specified legislature. Requires a working Internet connection.
}
\examples{
\donttest{# Get entire 'Core' table for the German Bundestag
deu_core <- get_core(legislature = "deu")
tibble::glimpse(deu_core)

# Get 'Core' table for 16th session of the German Bundestag
deu_core_subset <- dplyr::semi_join(x = deu_core,
                                    y = dplyr::filter(get_political(legislature = "deu"),
                                                      session == 16),
                                    by = "pageid")
tibble::glimpse(deu_core_subset)
}
}
