% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-methods.R
\name{KDTree}
\alias{KDTree}
\title{KDTree - Nearest Neighbor Search}
\value{
R6 Class of KDTree
}
\description{
Wrapper R6 Class of RANN::nn2 function that can be used for LESSRegressor and LESSClassifier
}
\examples{

## ------------------------------------------------
## Method `KDTree$new`
## ------------------------------------------------

data(abalone)
kdt <- KDTree$new(abalone[1:100,])

## ------------------------------------------------
## Method `KDTree$query`
## ------------------------------------------------

res <- kdt$query(abalone[1:3,], k=2)
print(res)
}
\seealso{
\code{\link[RANN:nn2]{RANN::nn2()}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KDTree-new}{\code{KDTree$new()}}
\item \href{#method-KDTree-query}{\code{KDTree$query()}}
\item \href{#method-KDTree-clone}{\code{KDTree$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KDTree-new"></a>}}
\if{latex}{\out{\hypertarget{method-KDTree-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of KDTree
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KDTree$new(X = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X}}{An \strong{M x d} data.frame or matrix, where each of the \strong{M} rows is a point or a (column) vector (where \strong{d=1}).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(abalone)
kdt <- KDTree$new(abalone[1:100,])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KDTree-query"></a>}}
\if{latex}{\out{\hypertarget{method-KDTree-query}{}}}
\subsection{Method \code{query()}}{
Finds the p number of near neighbours for each point in an input/output dataset. The advantage of the kd-tree is that it runs in O(M log M) time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KDTree$query(query_X = private$X, k = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_X}}{A set of \strong{N x d} points that will be queried against \code{X}. \strong{d}, the number of columns, must be the same as \code{X}.
If missing, defaults to  \code{X}.}

\item{\code{k}}{The maximum number of nearest neighbours to compute (deafults to 1).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{list} of length 2 with elements:\tabular{ll}{
\code{nn.idx} \tab A \strong{N x k} integer matrix returning the near neighbour indices. \cr
\tab \cr
\code{nn.dists} \tab A \strong{N x k} matrix returning the near neighbour Euclidean distances \cr
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{res <- kdt$query(abalone[1:3,], k=2)
print(res)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KDTree-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KDTree-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KDTree$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
