% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{icecream}
\alias{icecream}
\title{Icecream sales and temperature}
\format{A data frame with 40 rows and 3 variables:
\describe{
  \item{\code{temperature}}{double Air temperature (C)}
  \item{\code{sales}}{double Icecream sales per week (in local currency)}
  \item{\code{location}}{factor Either 'Dappermarkt' or 'Oosterpark'}
}}
\usage{
icecream
}
\description{
A synthetic dataset on weekly ice cream sales in two locations in Amsterdam,
along with air temperature. The idea is that the ice cream salesman first sold icecream in
'Oosterpark', and decided to move shop to the 'Dappermarkt' the year after. Did sales improve?
This dataset can be used to show that naive conclusions from simple linear model fits can
be misleading, and that the use of covariates (here, air temperature) can change conclusions
about effects.
}
\examples{
data(icecream)

# Linear model, temperature as covariate
fit_ice <- lm(sales ~ temperature*location, data=icecream)

# Try to guess from coefficients where the sales were higher:
summary(fit_ice)

# What about now?
with(icecream, plot(temperature, sales, pch=19, col=location))
legend("topleft", levels(icecream$location), fill=palette())
}
\keyword{datasets}
