% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_dGhalf}
\alias{compute_dGhalf}
\title{Compute Matrix Square Root Derivative}
\usage{
compute_dGhalf(
  dG_dlambda,
  nc,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{dG_dlambda}{List of \eqn{nc \times nc} \eqn{d\textbf{G}/d\lambda} matrices by partition}

\item{nc}{Integer; number of columns per partition}

\item{K}{Integer; number of interior knots (\eqn{K})}

\item{parallel, cl, chunk_size, num_chunks, rem_chunks}{Parallel computation parameters}
}
\value{
List of \eqn{nc \times nc} matrices containing \eqn{d\textbf{G}_k^{1/2}/d\lambda} for each partition k
}
\description{
Calculates \eqn{d\textbf{G}^{1/2}/d\lambda} matrices for each partition using eigendecomposition.
Follows similar approach to \code{compute_G_eigen()} but for matrix derivatives.
}
\keyword{internal}
