% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leave_one_out.R
\name{leave_one_out}
\alias{leave_one_out}
\title{Compute Leave-One-Out Cross-Validated predictions for
Gaussian Response/Identity Link under Constraint.}
\usage{
leave_one_out(model_fit)
}
\arguments{
\item{model_fit}{A fitted Lagrangian smoothing spline model}
}
\value{
A vector of leave-one-out cross-validated predictions
}
\description{
Computes the leave-one-out cross-validated predictions from a model fit,
assuming Gaussian-distributed response with identity link.
}
\examples{

## Basic usage with Gaussian response, computing PRESS
set.seed(1234)
t <- rnorm(50)
y <- sin(t) + rnorm(50, 0, .25)
fit <- lgspline(t, y)
loo <- leave_one_out(fit)
press <- mean((y-loo)^2)

plot(loo, y,
   main = "Leave-One-Out Cross-Validation Prediction vs. Observed Response",
   xlab = 'Prediction', ylab = 'Response')
abline(0, 1)

}
