% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vb_bind_nll.R
\name{vb_bind_nll}
\alias{vb_bind_nll}
\title{Negative log-likelihood for potentially constrained von Bertalanffy growth model (typically used internally).}
\usage{
vb_bind_nll(theta, binding, data, distribution)
}
\arguments{
\item{theta}{A parameter vector of the same length as the maximum of \code{binding}. Unconstrained parameters take the order: lnlinfF, lnlinfM, lnkF, lnkM, lnnt0F, lnnt0M, lnsigmaF, lnsigmaM.}

\item{binding}{A (4x2) parameter index matrix with rows named (in order): "lnlinf", "lnk", "lnnt0", "lnsigma" and the left column for the female parameter index and right column for male parameter index. Used to impose arbitrary equality constraints across the sexes (see Examples).}

\item{data}{data.frame with columns: "age", "length" and "weights". "weights" are set to 1 or 0 for known females or males, respectively; proportions otherwise.}

\item{distribution}{Character with options: "normal" or "lognormal"}
}
\value{
Complete data negative log-likelihood:
}
\description{
\code{vb_bind_nll} returns the negative log-likelihood for the von Bertalanffy model. Equality constraints across sexes can be implemented for any combination of parameters using the \code{binding} argument.
}
\examples{
## Unconstrained model 
binding <- matrix(c(1:8), ncol = 2, byrow = TRUE)
rownames(binding) <- c("lnlinf", "lnk", "lnnt0", "lnsigma")
colnames(binding) <- c("female", "male")
## starting values 
start.par <- c(rep(log(25), 2), rep(log(0.2), 2), rep(log(3), 2), rep(log(1), 2))
vb_bind_nll(theta = start.par, binding = binding,
            data = data.frame(age = rep(1, 2), length = rep(10, 2), weights = c(1, 0)),
            distribution = "normal")
}
