% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vb_growth_mix.R
\name{vb_growth_mix}
\alias{vb_growth_mix}
\title{Fit finite mixture von Bertalanffy growth model.}
\source{
Minto, C., Hinde, J. and Coelho, R. (2017). Including unsexed individuals in sex-specific growth models.
\emph{Canadian Journal of Fisheries and Aquatic Sciences}. DOI: 10.1139/cjfas-2016-0450.
}
\usage{
vb_growth_mix(start.list, data, binding, maxiter.em = 1000, reltol = 1e-08,
  plot.fit = FALSE, verbose = TRUE, optim.method = "BFGS",
  estimate.mixprop = TRUE, distribution)
}
\arguments{
\item{start.list}{A list with a list called par containing starting values for: "mixprop", "growth.par" (see Examples).}

\item{data}{A data.frame with columns: "age", "length" and "obs.sex". "obs.sex" must have values "female", "male", "unclassified".}

\item{binding}{A (4x2) parameter index matrix with rows named (in order): "lnlinf", "lnk", "lnnt0", "lnsigma" and the left column for the female parameter index and right column for male parameter index. Used to impose arbitrary equality constraints across the sexes (see Examples).}

\item{maxiter.em}{Integer for maximum number of EM iterations (1e3 default).}

\item{reltol}{Relative tolerance for EM observed data log likelihood convergence (1e-8 default).}

\item{plot.fit}{Logical, if TRUE fit plotted per iteration. Red and blue circles are used for known females and males, respectively. Unclassified animals are plotted as triangle with the colour indicating the expected probability of being female or male (FALSE default).}

\item{verbose}{Logical, if TRUE iteration and observed data log-likelihood printed.}

\item{optim.method}{Character, complete data optimisation method to use in \code{optim}.}

\item{estimate.mixprop}{Logical, if TRUE the mixing proportion is estimated, otherwise fixed at the starting value.}

\item{distribution}{Character with options: "normal" or "lognormal".}
}
\value{
List containing the components:
\item{logLik.vec}{Observed data log-likelihood at each iteration.}
\item{logLik}{Observed data log-likelihood on the last EM iteration.}
\item{complete_data}{Data frame of the data (re-ordered) with component probabilities (tau).}
\item{coefficients}{Parameter estimates (on the real line) and associated standard errors on the real line.}
\item{vcov}{Estimated variance covariance matrix of the parameters estimated on the real line. Can be used to obtain parameter standard errors on the natural scale.}
\item{convergence}{Binary with a "0" denoting convergence of the EM algorithm.}
}
\description{
\code{vb_growth_mix} fits sex-specific growth models where some of the animals are of unknown sex. Optimisation is via the Expectation-Maximisation algorithm. Equality constraints across sexes can be implemented for any combination of parameters using the \code{binding} argument.
}
\examples{
set.seed(1010)
sim.dat <- sim_vb_data(nfemale = 50, nmale = 50, mean_ageF = 4, mean_ageM = 4,
                      growth_parF = c(linf = 30, k = 0.5, t0 = -1, sigma = 0.1),
                      growth_parM = c(linf = 25, k = 0.5, t0 = -1, sigma = 0.1),
                      mat_parF = c(A50 = 5, MR = 2), mat_parM = c(A50 = 3, MR = 2),
                      distribution = "lognormal")

## Model fit with contrained Brody's growth coefficient
## Set up the constraint
binding <- matrix(c(1:2, rep(3, 2), 4:7), ncol = 2, byrow = TRUE)
rownames(binding) <- c("lnlinf", "lnk", "lnnt0", "lnsigma")
colnames(binding) <- c("female", "male")
## note: lnnt0 is the natural logarithm of the negative of t0 (t0 < 0)
## starting values 
start.par <- c(c(log(30), log(25)), rep(log(0.3), 1), rep(log(1), 2), rep(log(.1), 2))
start.list <- list(par = list(mixprop = 0.5, growth.par = start.par))
vb.bind.fit <- vb_growth_mix(data = sim.dat, start.list = start.list,
                             binding = binding, distribution = "lognormal",
                             reltol = 1e-6)

}
