% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-attributes.R
\name{set_lb_attribute}
\alias{set_lb_attribute}
\title{Set special libbib attribute on object}
\usage{
set_lb_attribute(x, type, value)
}
\arguments{
\item{x}{An object to set the attribute on}

\item{type}{The name of the attribute to set. \code{lb.} will be appended
to this attribute name. For example, if this argument is
\code{source}, and attribute called \code{lb.source} will
be set on the object with the value specified}

\item{value}{The value of the attribute}
}
\value{
Nothing, since the object is modified by reference.
}
\description{
Takes an object, attribute name, and a value and sets a special
libbib attribute by reference
}
\examples{
set_lb_attribute(mtcars, "source", "R built-in dataset")

versicolor <- iris[iris$Species=="versicolor", ]
set_lb_attribute(versicolor, "note", "modified built-in dataset")
attributes(versicolor)$lb.note
# [1] "modified built-in dataset"

}
