# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# boston_pts

library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("boston_pts is a data.frame", {
  expect_s3_class(boston_pts, "data.frame")
})

# Test 2: Confirm it has exactly 20 columns
test_that("boston_pts has 20 columns", {
  expect_equal(length(boston_pts), 20)
})

# Test 3: Confirm it has exactly 506 rows
test_that("boston_pts has 506 rows", {
  expect_equal(nrow(boston_pts), 506)
})

# Test 4: Confirm column names are correct
test_that("boston_pts has correct column names", {
  expect_named(boston_pts, c(
    "TOWN", "TOWNNO", "TRACT", "LON", "LAT", "MEDV", "CMEDV", "CRIM",
    "ZN", "INDUS", "CHAS", "NOX", "RM", "AGE", "DIS", "RAD",
    "TAX", "PTRATIO", "B", "LSTAT"
  ))
})

# Test 5: Confirm column types are as expected
test_that("boston_pts columns have correct types", {
  expect_s3_class(boston_pts$TOWN, "factor")
  expect_type(boston_pts$TOWNNO, "integer")
  expect_type(boston_pts$TRACT, "integer")
  expect_type(boston_pts$LON, "double")
  expect_type(boston_pts$LAT, "double")
  expect_type(boston_pts$MEDV, "double")
  expect_type(boston_pts$CMEDV, "double")
  expect_type(boston_pts$CRIM, "double")
  expect_type(boston_pts$ZN, "double")
  expect_type(boston_pts$INDUS, "double")
  expect_s3_class(boston_pts$CHAS, "factor")
  expect_type(boston_pts$NOX, "double")
  expect_type(boston_pts$RM, "double")
  expect_type(boston_pts$AGE, "double")
  expect_type(boston_pts$DIS, "double")
  expect_type(boston_pts$RAD, "integer")
  expect_type(boston_pts$TAX, "integer")
  expect_type(boston_pts$PTRATIO, "double")
  expect_type(boston_pts$B, "double")
  expect_type(boston_pts$LSTAT, "double")
})
