% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_tests.R
\name{is_events}
\alias{is_events}
\title{Validate Event Table}
\usage{
is_events(x, verbose = FALSE)
}
\arguments{
\item{x}{An R object.}

\item{verbose}{Logical value indicating whether to print the reason for test failure.}
}
\description{
Tests whether the object meets the basic requirements of an event table, i.e. a data frame containing at least two numeric, finite columns named 'from' and 'to' ordered such that \code{to} > or = \code{from} on all rows.
}
\examples{
verbose <- TRUE
is_events(c(1, 3), verbose)
is_events(data.frame(from = 1, t = 3), verbose)
is_events(data.frame(from = 1, from = 1, to = 3), verbose)
is_events(data.frame(from = 1, to = TRUE), verbose)
is_events(data.frame(from = 1, to = NA), verbose)
is_events(data.frame(from = 3, to = 1), verbose)
is_events(data.frame(from = 1, to = 3), verbose)   # TRUE
}
\seealso{
\code{\link{events}}, \code{\link{as_events}}, and \code{\link{read_events}} for creating valid event tables.
}
