% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{to_datetime}
\alias{to_datetime}
\title{Convert event endpoints to date-times}
\usage{
to_datetime(e, tz = "UTC", origin = as.POSIXct("1970-01-01", tz = "UTC"))
}
\arguments{
\item{e}{Event table or atomic vector.}

\item{tz}{Time zone (see \code{\link[base]{timezones}}).}

\item{origin}{Date-time object (see \code{\link[base]{as.POSIXct}}).}
}
\description{
Convert event endpoints to date-times
}
\examples{
t <- as.POSIXct("1970-01-01", tz = "UTC") + 0:4
e <- events(t)
to_datetime(e)
to_datetime(e$from)
}
