% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{wald_test}
\alias{wald_test}
\title{Wald test.
Tests restrictions*coefficients = value.}
\usage{
wald_test(
  model,
  restrictions,
  value,
  robust = FALSE,
  vcov = NULL,
  quantiles = c(0.9, 0.95, 0.99)
)
}
\arguments{
\item{model}{Model compatible with
`fitted` and `residuals` functions.}

\item{restrictions}{Matrix of size (number of restrictions) times length(coefficients),
for free restrictions use zeros.}

\item{value}{Values of restrictions.}

\item{robust}{Use robust `varcov` matrix.}

\item{vcov}{Particular variance and covariances matrix.}

\item{quantiles}{Vector of quantiles to calculate pvalues.}
}
\value{
A `tibbble` with the Wald value, the corresponding pvalue and the quantiles of the distribution.
}
\description{
Wald test.
Tests restrictions*coefficients = value.
}
\examples{
x <- 1:10
z <- x**2
y <- 1:10
model <- lm(y~x+z)
restrictions <- diag(3)
value <-  as.matrix(c(0, 0, 0))
w_test <- wald_test(model, restrictions, value)
w_test <- wald_test(model, restrictions, value, robust = TRUE)
w_test <- wald_test(model, restrictions, value, quantiles = c(.97))
}
