% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rnb}
\alias{rnb}
\title{Generate Random Samples from a Negative Binomial Distribution}
\usage{
rnb(r, p)
}
\arguments{
\item{r}{The number of failures before achieving a specified number of successes in a negative binomial experiment. It also serves as the dispersion parameter which controls the variance of the distribution.}

\item{p}{The probability of success on each independent Bernoulli trial within the negative binomial experiment.}
}
\value{
A random value sampled from the negative binomial distribution with parameters \code{r} and \code{p}.
}
\description{
This function generates random samples from a negative binomial distribution with the specified dispersion parameter (\code{r}) and success probability (\code{p}).
}
\examples{
r <- 2
p <- 0.3
rnb(r, p)
}
