% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.linelist.R
\name{print.linelist}
\alias{print.linelist}
\title{Printing method for linelist objects}
\usage{
\method{print}{linelist}(x, ...)
}
\arguments{
\item{x}{a \code{linelist} object}

\item{...}{further arguments to be passed to 'print'}
}
\value{
Invisibly returns the object.
}
\description{
This function prints linelist objects.
}
\examples{
if (require(outbreaks)) {

  ## dataset we'll create a linelist from
  measles_hagelloch_1861

  ## create linelist
  x <- make_linelist(measles_hagelloch_1861,
    id = "case_ID",
    date_onset = "date_of_prodrome",
    age = "age",
    gender = "gender"
  )

  ## print object - using only the first few entries
  head(x)

  # version with a tibble
  if (require(tibble)) {
    measles_hagelloch_1861 |>
      tibble() |>
      make_linelist(
        id = "case_ID",
        date_onset = "date_of_prodrome",
        age = "age",
        gender = "gender"
      )
  }
}
}
