% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linemap.R
\name{linemap}
\alias{linemap}
\title{Create Line Map}
\usage{
linemap(
  x,
  k = 2,
  threshold = 1,
  col = "white",
  border = "black",
  lwd = 0.5,
  bg = par("bg"),
  add = FALSE
)
}
\arguments{
\item{x}{a data.frame (x, y, value), a terra SpatRaster.}

\item{k}{expension factor.}

\item{threshold}{threshold of the data to plot.}

\item{col}{color for the lines areas.}

\item{border}{color for the lines borders.}

\item{lwd}{thickness of the lines.}

\item{bg}{background color}

\item{add}{if TRUE add the lines to the current plot.}
}
\description{
Plot a line map.
}
\examples{
ras <- terra::rast(system.file("tif/elevation.tif", package = "linemap"))
linemap(ras, k = 7)
}
