% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.R
\name{update_dt_selection}
\alias{update_dt_selection}
\title{Update DT Selection Based on Shared ID}
\usage{
update_dt_selection(component_id, selected_id, session, components)
}
\arguments{
\item{component_id}{Character string. The ID of the DT component to update.}

\item{selected_id}{The shared ID value to select. If NULL, deselects all rows.}

\item{session}{'shiny' session object for the current user session.}

\item{components}{List containing component configuration information, including
data reactives, shared ID columns, and optional custom click handlers.}
}
\value{
NULL (invisible). Function is called for side effects only.
}
\description{
\code{update_dt_selection} Updates the selection state of a DataTable (DT) component when a shared ID
is selected or deselected from another linked component. This function handles
both custom click handlers and default selection behavior.
}
\details{
The function performs the following steps:
\itemize{
\item Validates that the DT package is available
\item Retrieves current data from the component's reactive data source
\item Validates that the shared ID column exists in the data
\item Creates a DT proxy for programmatic table manipulation
\item Finds the matching row based on the shared ID
\item Executes either custom click handler or default selection behavior
}
}
\section{Custom Click Handlers}{

If a custom click handler is provided in the component configuration
(\code{component_info$config$click_handler}), it will be called with
the DT proxy, selected data (or NULL for deselection), and session.
Otherwise, default row selection/deselection is performed.
}

