% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFdiscretization.R
\name{EFdiscretization}
\alias{EFdiscretization}
\title{EF: Equal-Frequency discretization}
\usage{
EFdiscretization(continuousX, nX, nbdigitsX = 3)
}
\arguments{
\item{continuousX}{a vector of numeric.}

\item{nX}{an integer corresponding to the desired number of intervals.}

\item{nbdigitsX}{number of significant digits to use in constructing levels. Default is 3.}
}
\value{
a factor.
}
\description{
Discretize a quantitative variable with equal frequency binning if possible
}
\examples{
data(iris)
disc.Sepal.Length=EFdiscretization(iris$Sepal.Length,5)
summary(disc.Sepal.Length)

}
