% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_select.R
\name{list_select}
\alias{list_select}
\title{Select parts of a list.}
\usage{
list_select(in_list, ...)
}
\arguments{
\item{in_list}{The list to select from.}

\item{...}{The selection, can both be names and numeric positions.}
}
\value{
A list of the selected elements.
}
\description{
Select parts of a list.
}
\details{
`list_select()` lets you select parts of a list either by position or
by name.
Names can be supplied as bare variable names and do not need to be
supplied as strings or otherwise be quoted.

Elements are returned in the order they are given, this is useful if you
want to reorder elements in a list.
You can also rename while selecting, writing your selection like
`new_name = old_name`.
}
\examples{
my_list <- list(a = c(1, 2), b = c(3, 4), c(5, 6))
list_select(my_list, a, 3)
}
