% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fliteReturnLevelMethods.R
\name{returnLevelMethods}
\alias{returnLevelMethods}
\alias{plot.returnLevel}
\alias{print.returnLevel}
\alias{summary.returnLevel}
\alias{print.summary.returnLevel}
\title{Methods for objects of class \code{"returnLevel"}}
\usage{
\method{plot}{returnLevel}(x, level = NULL, legend = TRUE, digits = 3, plot = TRUE, ...)

\method{print}{returnLevel}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{summary}{returnLevel}(object, digits, ...)

\method{print}{summary.returnLevel}(x, ...)
}
\arguments{
\item{x}{an object of class \code{c("returnLevel", "lite")}, a result
of a call to \code{\link{returnLevel}}, using \code{prof = TRUE}.}

\item{level}{A numeric scalar in (0, 1).  The confidence level required for
the confidence interval for the \code{m}-year return level.
If \code{level} is not supplied then \code{x$level} is used.
\code{level} must be no larger than \code{x$level}.}

\item{legend}{A logical scalar.  Should we add a legend (in the top right
of the plot) that gives the approximate values of the MLE and
100\code{level}\% confidence limits?}

\item{digits}{For \code{plot.returnLevel}: an integer. Passed to
  \code{\link[base:Round]{signif}} to round the values in the legend.

  For \code{print.returnLevel}: the argument \code{digits} to
  \code{\link{print.default}}.

  For \code{summary.returnLevel}: an integer. For number formatting
  with \code{\link[base:Round]{signif}}.  If \code{digits} is not specified
  (i.e. \code{\link{missing}}) then \code{signif()} will not be called
  (i.e. no rounding will be performed).}

\item{plot}{A logical scalar.  If \code{TRUE} then the plot is produced.
Otherwise, it is not, but the MLE and confidence limits are returned.}

\item{...}{For \code{plot.returnLevel}: arguments passed to
  \code{\link[graphics:plot.default]{plot}}, such as graphical parameters.

  For \code{print.summary.returnLevel}: arguments passed to
  \code{\link{print.default}}.}

\item{object}{an object of class \code{c("returnLevel", "lite")}, a result
of a call to \code{\link{returnLevel}}, using \code{prof = TRUE}.}
}
\value{
\code{plot.returnLevel}: a numeric vector of length 3 containing the
  lower 100\code{level}\% confidence limit, the MLE and the upper
  100\code{level}\% confidence limit is returned invisibly.

  \code{print.returnLevel}: the argument \code{x} is returned, invisibly.

  \code{summary.returnLevel}: a list containing the list element
  \code{object$call} and a matrix \code{matrix} containing the MLE
  and estimated SE of the return level.

  \code{print.summary.returnLevel}: the argument \code{x} is returned,
  invisibly.
}
\description{
Methods for objects of class \code{"returnLevel"} returned from
\code{\link{returnLevel}}.
}
\details{
\code{plot.returnLevel} plots the profile log-likelihood for a
  return level, provided that \code{x} returned by a call to
  \code{\link{returnLevel}} using \code{prof = TRUE}.  Horizontal lines
  indicate the values of the maximised log-likelihood and the critical level
  used to calculate the confidence limits.
  If \code{level} is smaller than \code{x$level} then approximate
  100\code{level}\% confidence limits are recalculated based on the
  information contained in \code{x$for_plot}.

\code{print.returnLevel} prints the call to
  \code{\link{returnLevel}} and the estimates and 100\code{x$level}\%
  confidence limits for the \code{x$m}-year return level.
}
\section{Examples}{

See \code{\link{returnLevel}}.
}

\seealso{
\code{\link{returnLevel}} to perform frequentist threshold-based
  inference for return levels.
}
