% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr.R
\name{mlr}
\alias{mlr}
\title{Multinomial Logistic Regression}
\usage{
mlr(y, X, base = "largest", maxiter = 65536, dcrit = 1e-06)
}
\arguments{
\item{y}{An N vector of the responses (categorical).}

\item{X}{An N by P matrix with predictor variables}

\item{base}{The category that should be used as baseline. Can be NULL, in which case the colmeans are equal to zero. Can also be "largest", in which case the}

\item{maxiter}{maximum number of iterations}

\item{dcrit}{convergence criterion}
}
\value{
Xoriginal Matrix X from input

X Scaled X matrix

G class indicator matrix

ynames class names of response variable

xnames variable names of the predictors

mx means of the predictor variables

sdx standard deviations of the predictor variables

A matrix with regression coefficients

iter number of iterations

deviance value of the deviance at convergence
}
\description{
The function mlr performs multinomial logistic regression
for a nominal response variable and a set of predictor variables.
It uses an MM algorithm
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mlr(y = y, X = X, base = 1)
}

}
