% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mrrr.R
\name{plot.mrrr}
\alias{plot.mrrr}
\title{Plots a Multinomial Reduced Rank Model}
\usage{
\method{plot}{mrrr}(
  x,
  dims = c(1, 2),
  ycol = "darkgreen",
  xcol = "darkblue",
  ocol = "grey",
  markersize = 2.5,
  labelsize = 3,
  ...
)
}
\arguments{
\item{x}{an object of type mrrr}

\item{dims}{which dimensions to visualize}

\item{ycol}{colour for representation of response variables}

\item{xcol}{colour for representation of predictor variables}

\item{ocol}{colour for representation of row objects}

\item{markersize}{determines the size of the markera}

\item{labelsize}{determines the size of the labels}

\item{\dots}{additional arguments to be passed.}
}
\value{
Plot of the results obtained from mrrr
}
\description{
Plots a Multinomial Reduced Rank Model
}
\examples{
\dontrun{
data(dataExample_mru)
y = as.matrix(dataExample_mru[ , 1])
X = as.matrix(dataExample_mru[ , 2:6])
output = mru(y = y, X = X, S = 2)
plot(output)
}

}
