% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuizResidual.r
\name{QuizResidual}
\alias{QuizResidual}
\title{QuizResidual shiny app}
\usage{
QuizResidual(
  ComputerDecision = ComputerDecision.default,
  Simulation = Simulation.default,
  dir.images = NULL,
  dir.sounds = NULL
)
}
\arguments{
\item{ComputerDecision}{the function to be used to state the answer of the computer player (see \code{\link{ComputerDecision.default}})}

\item{Simulation}{the function to be used to simulate data (see \code{\link{Simulation.default}})}

\item{dir.images}{the directory where images to be used by the shiny app are to be found, default to NULL, images from the package will be used}

\item{dir.sounds}{the directory where sounds to be used by the shiny app are to be found, default to NULL, sounds from the package will be used}
}
\value{
None
}
\description{
Launches the QuizResidual shiny app
}
\details{
QuizResidual shiny app is a game in which the player is asked to guess, based on four standard diagnostic plots of a linear model, whether there is a violation of one of the basic assumptions: linearity, homoscedasticity, normality of errors.

The program will simulate a sample (x,Y) from a randomly chosen data generating mechanism possibly violating one of the assumptions (function \code{\link{Simulation.default}}), fit a linear model and plot the diagnostic.

 The computer player makes a guess on whether there is a violation of assumptions (function \code{\link{ComputerDecision.default}}).

 After the answer is given, the true data generating mechanism will be shown in the plot, in particular, the true regression function, the true standard deviation of errors and the true density of errors.

 The game can be customized by coding your own Simulation and ComputerDecision functions passing them as arguments.

 Sounds will be played depending on whether the correct or wrong answer is given and a final sound is played depending on the outcome, also an appropriate image is shown. (Sounds are taken from the site https://freesound.org/, images from https://wpclipart.com and are public domain, other sounds and images can be used by calling the app with the directories where the images are stored as argument, sounds must be named as follows: suonorr: sound to be played when both the player and the computer give the correct answer; suonowr: sound to be played when the player is correct and the computer is wrong; suonorw and suonoww are analogous; suonofinaleP/V/S: final sound to play in case of tie/win/loss; immagineP/V/S: image to be shown in case of tie/win/loss.)
}
\examples{
## Not run:
if (interactive()){
  QuizResidual()
  # if custom sounds and images are in the directory www in the working directory
  QuizResidual(dir.images=paste0(getwd(),"/www"),dir.sounds=paste0(getwd(),"/www"))
}
## End(Not run)

}
\seealso{
\code{\link{ComputerDecision.default}}, \code{\link{Simulation.default}}
}
\author{
Francesco Pauli, \email{francesco.pauli@deams.units.it}
}
