% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_lslin.R
\name{summary.lslin}
\alias{summary.lslin}
\title{Summary of Linear Load Shape}
\usage{
\method{summary}{lslin}(object, ... = NULL)
}
\arguments{
\item{object}{An object of class \code{lslin},
created by the function \code{\link{lslin}}.}

\item{...}{\code{NULL}. Used for S3 generic/method consistency.}
}
\value{
\code{NULL}. Prints the summary of the derived
load shape using linear method.
}
\description{
Summary method of \code{lslin} object
}
\note{
Same as \code{\link{print.lslin}}
}
\examples{
# ---------------------
loads <- ercot[ercot$Year == 2019, ]$COAST
linear_loadshape <- lslog(loads, target_lf = 0.5, k = 0.5)
summary(linear_loadshape)
# ---------------------
loads2 <- ercot[ercot$Year == 2019, ]$ERCOT
linear_loadshape2 <- lslog(loads2, target_lf = 0.75, k = 1)
summary(linear_loadshape2)



}
\seealso{
\code{\link{lslin}}
}
