% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createWavList.R
\name{createWavList}
\alias{createWavList}
\title{Create a list of Wave objects.}
\usage{
createWavList(
  paths,
  names,
  from,
  to,
  buffer,
  adjustments,
  channels,
  index = "unknown"
)
}
\arguments{
\item{paths}{Character vector. File paths to the set of .wav files to be read.}

\item{names}{Character vector. Station names for the files. Must have the same length and
the names must occur in the same order as the \code{paths} variable.}

\item{from}{Numeric. Start time, in seconds, of the sound of interest, relative to
the start of the file.}

\item{to}{Numeric. End time, in seconds, of the sound of interest, relative to
the start of the file.}

\item{buffer}{Numeric. Amount of blank space around each sound of interest to be read.}

\item{adjustments}{Numeric vector. Amount, in seconds, to adjust the start times of recordings,
if not already synchronized. Vector must be of the same length as the
\code{paths} variable. If not specified, default is no adjustment.}

\item{channels}{Numeric vector. The channel to be read from each .wav file. Left = 1, Right = 2. If
missing, default is left channel (channel 1) for all recordings.}

\item{index}{Numeric. If using this function within a loop, pass the index i to the function, which
can help with troubleshooting if an error occurs.}
}
\value{
Named list of Wave objects.
}
\description{
This function reads in portions of a set of synchronized .wav files. It is intended to be used to load
sounds of interest for localization.
}
\examples{
    #list example mp3 files.
    wavs <- list.files(system.file('extdata', package = 'locaR'),
                       pattern = 'mp3$', full.names = TRUE)
    #get names of mp3 locations.
    nms <- substr(basename(wavs), 1, 4)
    #create wave list.
    wl <- createWavList(paths = wavs, names = nms, from = 1, to = 2, buffer = 0.1)
}
