% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validationSpec.R
\name{validationSpec}
\alias{validationSpec}
\title{Create validation spectrograms.}
\usage{
validationSpec(
  wavList,
  coordinates,
  locationEstimate,
  from,
  to,
  tempC = 15,
  soundSpeed,
  F_Low,
  F_High
)
}
\arguments{
\item{wavList}{list of Wave objects. The name of the Wave objects MUST be
present in the coordinates data.frame.}

\item{coordinates}{data.frame. Must contain four required columns:
column Station contains a character string with names of each recording
station, while Easting, Northing and Elevation contain the x, y, and z
coordinates of the station, in meters (E.g. UTM coordinates).}

\item{locationEstimate}{Dataframe with one row containing columns Easting, Northing and Elevation,
specifying the estimated location of the sound source.}

\item{from, to}{Numeric. The portion of the wavs to plot. If missing, the whole wav will be plotted.}

\item{tempC}{Numeric. The ambient temperature in celsius, which is used to calculate the speed
of sound in air if none is specified.}

\item{soundSpeed}{Numeric. The speed of sound. If missing, tempC will be used to calculate
the speed of sound in air.}

\item{F_Low, F_High}{Numeric. The low and high frequency, in Hz, of the sound
to be localized.}
}
\value{
No return value.
}
\description{
This function is used inside the \code{localize} function to create the panels of
synchronized spectrograms for manual review.
}
\examples{
    \donttest{
    #Get filepaths for example data.
    fp <- list.files(system.file('extdata', package = 'locaR'),
                      pattern = '.mp3', full.names = TRUE)
    #Add names.
    names(fp) <- sapply(strsplit(basename(fp), '_'), '[[', 1)
    #Load first row of detection data.
    row <- read.csv(system.file('extdata',
         'Vignette_Detections_20200617_090000.csv', package = 'locaR'),
          stringsAsFactors = FALSE)[1,]
    #Get non-empty Station columns.
    stationSubset <- unlist(row[1,paste0('Station',1:6)])
    stationSubset <- stationSubset[!is.na(stationSubset) & stationSubset != '']
    #Create wav list.
    wl <- createWavList(paths = fp[stationSubset], names = stationSubset,
           from = row$From, to = row$To, buffer = 0.2, index=1)
    #Read coordinates.
    coordinates <- read.csv(system.file('extdata', 'Vignette_Coordinates.csv',
                            package = 'locaR'), stringsAsFactors = FALSE)
    row.names(coordinates) <- coordinates$Station
    #Subset coordinates.
    crd <- coordinates[stationSubset,]
    #Localize.
    loc <- localize(wavList = wl, coordinates = crd, locFolder = tempdir(),
               F_Low = row$F_Low, F_High = row$F_High, jpegName = '0001.jpeg',
               keep.SearchMap = TRUE)
    #Create validation spectrogram.
    #Store old par
    oldpar <- par()$mfrow
    par(mfrow = c(6,1))
    validationSpec(wavList = wl, coordinates = crd, locationEstimate = loc$location,
                                 F_Low = row$F_Low, F_High = row$F_High)
    #Reset old par values.
    par(mfrow = oldpar)
    }
}
